/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.JdbcDriver;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.impl.UdfImpl;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.UdfUdafProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.calcite.v1_26_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_26_0.com.google.common.base.Strings;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.tools.RuleSet;

@Internal
@Experimental
public class BeamSqlEnv {
    JdbcConnection connection;
    QueryPlanner planner;

    private BeamSqlEnv(JdbcConnection connection, QueryPlanner planner) {
        this.connection = connection;
        this.planner = planner;
    }

    public static BeamSqlEnvBuilder builder(TableProvider tableProvider) {
        return new BeamSqlEnvBuilder(tableProvider);
    }

    public static BeamSqlEnv readOnly(String tableType, Map<String, BeamSqlTable> tables) {
        return BeamSqlEnv.withTableProvider(new ReadOnlyTableProvider(tableType, tables));
    }

    public static BeamSqlEnv withTableProvider(TableProvider tableProvider) {
        return BeamSqlEnv.builder(tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).build();
    }

    public static BeamSqlEnv inMemory(TableProvider ... tableProviders) {
        InMemoryMetaStore inMemoryMetaStore = new InMemoryMetaStore();
        for (TableProvider tableProvider : tableProviders) {
            inMemoryMetaStore.registerProvider(tableProvider);
        }
        return BeamSqlEnv.withTableProvider(inMemoryMetaStore);
    }

    public BeamRelNode parseQuery(String query) throws ParseException {
        return this.planner.convertToBeamRel(query, QueryPlanner.QueryParameters.ofNone());
    }

    public BeamRelNode parseQuery(String query, QueryPlanner.QueryParameters queryParameters) throws ParseException {
        return this.planner.convertToBeamRel(query, queryParameters);
    }

    public boolean isDdl(String sqlStatement) throws ParseException {
        return this.planner.parse(sqlStatement).getKind().belongsTo((Collection)SqlKind.DDL);
    }

    public void executeDdl(String sqlStatement) throws ParseException {
        BeamSqlParser.DDL_EXECUTOR.executeDdl(this.getContext(), this.planner.parse(sqlStatement));
    }

    public CalcitePrepare.Context getContext() {
        return this.connection.createPrepareContext();
    }

    public Map<String, String> getPipelineOptions() {
        return this.connection.getPipelineOptionsMap();
    }

    public String explain(String sqlString) throws ParseException {
        try {
            return RelOptUtil.toString((RelNode)this.planner.convertToBeamRel(sqlString, QueryPlanner.QueryParameters.ofNone()));
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse statement", e);
        }
    }

    public static class BeamSqlEnvBuilder {
        private static final String CALCITE_PLANNER = "org.apache.beam.sdk.extensions.sql.impl.CalciteQueryPlanner";
        private String queryPlannerClassName;
        private TableProvider defaultTableProvider;
        private String currentSchemaName;
        private Map<String, TableProvider> schemaMap;
        private Set<Map.Entry<String, Function>> functionSet;
        private boolean autoLoadUdfs;
        private PipelineOptions pipelineOptions;
        private Collection<RuleSet> ruleSets;

        private BeamSqlEnvBuilder(TableProvider tableProvider) {
            Preconditions.checkNotNull((Object)tableProvider, (Object)"Table provider for the default schema must be sets.");
            this.defaultTableProvider = tableProvider;
            this.queryPlannerClassName = CALCITE_PLANNER;
            this.schemaMap = new HashMap<String, TableProvider>();
            this.functionSet = new HashSet<Map.Entry<String, Function>>();
            this.autoLoadUdfs = false;
            this.pipelineOptions = null;
            this.ruleSets = BeamRuleSets.getRuleSets();
        }

        public BeamSqlEnvBuilder addSchema(String name, TableProvider tableProvider) {
            if (this.schemaMap.containsKey(name)) {
                throw new RuntimeException("Schema " + name + " is registered twice.");
            }
            this.schemaMap.put(name, tableProvider);
            return this;
        }

        public BeamSqlEnvBuilder setCurrentSchema(String name) {
            this.currentSchemaName = name;
            return this;
        }

        public BeamSqlEnvBuilder setRuleSets(Collection<RuleSet> ruleSets) {
            this.ruleSets = ruleSets;
            return this;
        }

        public BeamSqlEnvBuilder addUdf(String functionName, Class<?> clazz, String method) {
            this.functionSet.add(new AbstractMap.SimpleEntry<String, Function>(functionName, UdfImpl.create(clazz, method)));
            return this;
        }

        public BeamSqlEnvBuilder addUdf(String functionName, Class<? extends BeamSqlUdf> clazz) {
            return this.addUdf(functionName, clazz, "eval");
        }

        public BeamSqlEnvBuilder addUdf(String functionName, SerializableFunction sfn) {
            return this.addUdf(functionName, sfn.getClass(), "apply");
        }

        public BeamSqlEnvBuilder addUdaf(String functionName, Combine.CombineFn combineFn) {
            this.functionSet.add(new AbstractMap.SimpleEntry(functionName, new UdafImpl(combineFn)));
            return this;
        }

        public BeamSqlEnvBuilder autoLoadUserDefinedFunctions() {
            this.autoLoadUdfs = true;
            return this;
        }

        public BeamSqlEnvBuilder setQueryPlannerClassName(String name) {
            this.queryPlannerClassName = name;
            return this;
        }

        public BeamSqlEnvBuilder setPipelineOptions(PipelineOptions pipelineOptions) {
            this.pipelineOptions = pipelineOptions;
            return this;
        }

        public BeamSqlEnv build() {
            Preconditions.checkNotNull((Object)this.pipelineOptions);
            JdbcConnection jdbcConnection = JdbcDriver.connect(this.defaultTableProvider, this.pipelineOptions);
            this.configureSchemas(jdbcConnection);
            QueryPlanner planner = this.instantiatePlanner(jdbcConnection, this.ruleSets);
            this.loadUdfs();
            this.addUdfsUdafs(jdbcConnection);
            return new BeamSqlEnv(jdbcConnection, planner);
        }

        private void configureSchemas(JdbcConnection jdbcConnection) {
            this.schemaMap.forEach(jdbcConnection::setSchema);
            if (Strings.isNullOrEmpty((String)this.currentSchemaName)) {
                return;
            }
            try {
                jdbcConnection.setSchema(this.currentSchemaName);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private void loadUdfs() {
            if (!this.autoLoadUdfs) {
                return;
            }
            ServiceLoader.load(UdfUdafProvider.class).forEach(ins -> {
                ins.getBeamSqlUdfs().forEach(this::addUdf);
                ins.getSerializableFunctionUdfs().forEach(this::addUdf);
                ins.getUdafs().forEach(this::addUdaf);
            });
        }

        private void addUdfsUdafs(JdbcConnection connection) {
            for (Map.Entry<String, Function> functionEntry : this.functionSet) {
                connection.getCurrentSchemaPlus().add(functionEntry.getKey(), functionEntry.getValue());
            }
        }

        private QueryPlanner instantiatePlanner(JdbcConnection jdbcConnection, Collection<RuleSet> ruleSets) {
            QueryPlanner.Factory factory;
            Class<?> queryPlannerClass;
            try {
                queryPlannerClass = Class.forName(this.queryPlannerClassName);
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Cannot find requested QueryPlanner class: " + this.queryPlannerClassName, exc);
            }
            try {
                factory = (QueryPlanner.Factory)queryPlannerClass.getField("FACTORY").get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException exc) {
                throw new RuntimeException(String.format("QueryPlanner class %s does not have an accessible static field 'FACTORY' of type QueryPlanner.Factory", this.queryPlannerClassName), exc);
            }
            return factory.createPlanner(jdbcConnection, ruleSets);
        }
    }
}

