/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.extensions.sql.impl.JavaUdfLoader;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.udf.AggregateFn;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class LazyAggregateCombineFn<InputT, AccumT, OutputT>
extends Combine.CombineFn<InputT, AccumT, OutputT> {
    private final List<String> functionPath;
    private final String jarPath;
    @Nullable
    private transient AggregateFn<InputT, AccumT, OutputT> aggregateFn = null;

    public LazyAggregateCombineFn(List<String> functionPath, String jarPath) {
        this.functionPath = functionPath;
        this.jarPath = jarPath;
    }

    @VisibleForTesting
    LazyAggregateCombineFn(AggregateFn aggregateFn) {
        this.functionPath = ImmutableList.of();
        this.jarPath = "";
        this.aggregateFn = aggregateFn;
    }

    private AggregateFn<InputT, AccumT, OutputT> getAggregateFn() {
        if (this.aggregateFn == null) {
            JavaUdfLoader loader = new JavaUdfLoader();
            this.aggregateFn = loader.loadAggregateFunction(this.functionPath, this.jarPath);
        }
        return this.aggregateFn;
    }

    public AccumT createAccumulator() {
        return (AccumT)this.getAggregateFn().createAccumulator();
    }

    public AccumT addInput(AccumT mutableAccumulator, InputT input) {
        return (AccumT)this.getAggregateFn().addInput(mutableAccumulator, input);
    }

    public AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
        AccumT first = accumulators.iterator().next();
        SkipFirstElementIterable<AccumT> rest = new SkipFirstElementIterable<AccumT>(accumulators);
        return (AccumT)this.getAggregateFn().mergeAccumulators(first, rest);
    }

    public OutputT extractOutput(AccumT accumulator) {
        return (OutputT)this.getAggregateFn().extractOutput(accumulator);
    }

    public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
        return registry.getCoder(this.getAggregateFn().getClass(), AggregateFn.class, (Map)ImmutableMap.of((Object)this.getInputTVariable(), inputCoder), this.getAccumTVariable());
    }

    public TypeVariable<?> getAccumTVariable() {
        return AggregateFn.class.getTypeParameters()[1];
    }

    public UdafImpl getUdafImpl() {
        return new LazyUdafImpl(this);
    }

    public String toString() {
        return String.format("%s %s from jar %s", LazyAggregateCombineFn.class.getSimpleName(), String.join((CharSequence)".", this.functionPath), this.jarPath);
    }

    private static class LazyUdafImpl<InputT, AccumT, OutputT>
    extends UdafImpl {
        private final LazyAggregateCombineFn<InputT, AccumT, OutputT> lazyFn;

        public LazyUdafImpl(LazyAggregateCombineFn lazyFn) {
            super(lazyFn);
            this.lazyFn = lazyFn;
        }

        private Type[] getTypeArguments() {
            for (Class<?> clazz = ((LazyAggregateCombineFn)this.lazyFn).getAggregateFn().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Type genericInterface : clazz.getGenericInterfaces()) {
                    ParameterizedType parameterizedType;
                    if (!(genericInterface instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericInterface).getRawType().equals(AggregateFn.class)) continue;
                    return parameterizedType.getActualTypeArguments();
                }
            }
            throw new IllegalStateException(String.format("Cannot get type arguments for %s: must implement parameterized %s", new Object[]{this.lazyFn, AggregateFn.class.getSimpleName()}));
        }

        @Override
        protected Type getInputType() {
            return this.getTypeArguments()[0];
        }

        @Override
        protected Type getOutputType() {
            return this.getTypeArguments()[2];
        }
    }

    private static class SkipFirstElementIterable<T>
    implements Iterable<T> {
        private final Iterable<T> all;

        SkipFirstElementIterable(Iterable<T> all) {
            this.all = all;
        }

        @Override
        public Iterator<T> iterator() {
            Iterator<T> it = this.all.iterator();
            it.next();
            return it;
        }
    }
}

