/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.JavaUdfLoader;
import org.apache.beam.sdk.extensions.sql.udf.AggregateFn;
import org.apache.beam.sdk.transforms.Combine;

public class LazyAggregateCombineFn<InputT, AccumT, OutputT>
extends Combine.CombineFn<InputT, AccumT, OutputT> {
    private final List<String> functionPath;
    private final String jarPath;
    @Nullable
    private transient AggregateFn<InputT, AccumT, OutputT> aggregateFn = null;

    public LazyAggregateCombineFn(List<String> functionPath, String jarPath) {
        this.functionPath = functionPath;
        this.jarPath = jarPath;
    }

    private AggregateFn<InputT, AccumT, OutputT> getAggregateFn() {
        if (this.aggregateFn == null) {
            JavaUdfLoader loader = new JavaUdfLoader();
            this.aggregateFn = loader.loadAggregateFunction(this.functionPath, this.jarPath);
        }
        return this.aggregateFn;
    }

    public AccumT createAccumulator() {
        return (AccumT)this.getAggregateFn().createAccumulator();
    }

    public AccumT addInput(AccumT mutableAccumulator, InputT input) {
        return (AccumT)this.getAggregateFn().addInput(mutableAccumulator, input);
    }

    public AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
        Iterator<AccumT> it = accumulators.iterator();
        AccumT first = it.next();
        it.remove();
        return (AccumT)this.getAggregateFn().mergeAccumulators(first, accumulators);
    }

    public OutputT extractOutput(AccumT accumulator) {
        return (OutputT)this.getAggregateFn().extractOutput(accumulator);
    }
}

