/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.TimeZone;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.AvaticaResultSetMetaData;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.Handler;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.Meta;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.Cursor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Enumerator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Linq4j;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.runtime.ArrayEnumeratorCursor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.runtime.ObjectEnumeratorCursor;

public class CalciteResultSet
extends AvaticaResultSet {
    CalciteResultSet(AvaticaStatement statement, CalcitePrepare.CalciteSignature calciteSignature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) {
        super(statement, null, calciteSignature, resultSetMetaData, timeZone, firstFrame);
    }

    @Override
    protected CalciteResultSet execute() throws SQLException {
        CalciteConnectionImpl connection = this.getCalciteConnection();
        boolean autoTemp = connection.config().autoTemp();
        Handler.ResultSink resultSink = null;
        if (autoTemp) {
            resultSink = new Handler.ResultSink(){

                @Override
                public void toBeCompleted() {
                }
            };
        }
        connection.getDriver().handler.onStatementExecute(this.statement, resultSink);
        super.execute();
        return this;
    }

    @Override
    public ResultSet create(ColumnMetaData.AvaticaType elementType, Iterable<Object> iterable) {
        List<ColumnMetaData> columnMetaDataList = elementType instanceof ColumnMetaData.StructType ? ((ColumnMetaData.StructType)elementType).columns : ImmutableList.of(ColumnMetaData.dummy(elementType, false));
        CalcitePrepare.CalciteSignature signature = (CalcitePrepare.CalciteSignature)this.signature;
        CalcitePrepare.CalciteSignature newSignature = new CalcitePrepare.CalciteSignature(signature.sql, signature.parameters, signature.internalParameters, signature.rowType, columnMetaDataList, Meta.CursorFactory.ARRAY, signature.rootSchema, ImmutableList.of(), -1L, null);
        AvaticaResultSetMetaData subResultSetMetaData = new AvaticaResultSetMetaData(this.statement, null, newSignature);
        CalciteResultSet resultSet = new CalciteResultSet(this.statement, signature, subResultSetMetaData, this.localCalendar.getTimeZone(), new Meta.Frame(0L, true, iterable));
        Cursor cursor = resultSet.createCursor(elementType, iterable);
        return resultSet.execute2(cursor, columnMetaDataList);
    }

    private Cursor createCursor(ColumnMetaData.AvaticaType elementType, Iterable iterable) {
        Enumerator<Object> enumerator = Linq4j.iterableEnumerator(iterable);
        return !(elementType instanceof ColumnMetaData.StructType) || ((ColumnMetaData.StructType)elementType).columns.size() == 1 ? new ObjectEnumeratorCursor(enumerator) : new ArrayEnumeratorCursor((Enumerator<Object[]>)enumerator);
    }

    <T> CalcitePrepare.CalciteSignature<T> getSignature() {
        return (CalcitePrepare.CalciteSignature)this.signature;
    }

    CalciteConnectionImpl getCalciteConnection() {
        return (CalciteConnectionImpl)this.statement.getConnection();
    }
}

