/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.commons.csv.CSVFormat;

public class BeamTextCSVTableIOWriter
extends PTransform<PCollection<BeamRecord>, PDone>
implements Serializable {
    private String filePattern;
    protected BeamRecordSqlType beamRecordSqlType;
    protected CSVFormat csvFormat;

    public BeamTextCSVTableIOWriter(BeamRecordSqlType beamRecordSqlType, String filePattern, CSVFormat csvFormat) {
        this.filePattern = filePattern;
        this.beamRecordSqlType = beamRecordSqlType;
        this.csvFormat = csvFormat;
    }

    public PDone expand(PCollection<BeamRecord> input) {
        return (PDone)((PCollection)input.apply("encodeRecord", (PTransform)ParDo.of((DoFn)new DoFn<BeamRecord, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctx) {
                BeamRecord row = (BeamRecord)ctx.element();
                ctx.output((Object)BeamTableUtils.beamRecord2CsvLine(row, BeamTextCSVTableIOWriter.this.csvFormat));
            }
        }))).apply((PTransform)TextIO.write().to(this.filePattern));
    }
}

