/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.AutoValue_SqlTransform;
import org.apache.beam.sdk.extensions.sql.AutoValue_SqlTransform_UdafDefinition;
import org.apache.beam.sdk.extensions.sql.AutoValue_SqlTransform_UdfDefinition;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamPCollectionTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
@Experimental
@AutoValue.CopyAnnotations
public abstract class SqlTransform
extends PTransform<PInput, PCollection<Row>> {
    static final @UnknownKeyFor @NonNull @Initialized String PCOLLECTION_NAME = "PCOLLECTION";

    abstract @UnknownKeyFor @NonNull @Initialized String queryString();

    abstract @UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters queryParameters();

    abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized UdfDefinition> udfDefinitions();

    abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized UdafDefinition> udafDefinitions();

    abstract @UnknownKeyFor @NonNull @Initialized boolean autoUdfUdafLoad();

    abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> tableProviderMap();

    abstract @Nullable @UnknownKeyFor @Initialized String defaultTableProvider();

    abstract @Nullable @UnknownKeyFor @Initialized String queryPlannerClassName();

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PInput input) {
        BeamSqlEnv.BeamSqlEnvBuilder sqlEnvBuilder = BeamSqlEnv.builder(new ReadOnlyTableProvider(PCOLLECTION_NAME, this.toTableMap(input)));
        this.tableProviderMap().forEach(sqlEnvBuilder::addSchema);
        if (this.defaultTableProvider() != null) {
            sqlEnvBuilder.setCurrentSchema(this.defaultTableProvider());
        }
        sqlEnvBuilder.autoLoadBuiltinFunctions();
        this.registerFunctions(sqlEnvBuilder);
        if (this.autoUdfUdafLoad()) {
            sqlEnvBuilder.autoLoadUserDefinedFunctions();
        }
        sqlEnvBuilder.setQueryPlannerClassName((String)MoreObjects.firstNonNull((Object)this.queryPlannerClassName(), (Object)((BeamSqlPipelineOptions)input.getPipeline().getOptions().as(BeamSqlPipelineOptions.class)).getPlannerName()));
        sqlEnvBuilder.setPipelineOptions(input.getPipeline().getOptions());
        BeamSqlEnv sqlEnv = sqlEnvBuilder.build();
        return BeamSqlRelUtils.toPCollection(input.getPipeline(), sqlEnv.parseQuery(this.queryString(), this.queryParameters()));
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BeamSqlTable> toTableMap(@UnknownKeyFor @NonNull @Initialized PInput inputs) {
        if (inputs instanceof PCollection) {
            PCollection pCollection = (PCollection)inputs;
            return ImmutableMap.of((Object)PCOLLECTION_NAME, new BeamPCollectionTable(pCollection));
        }
        ImmutableMap.Builder tables = ImmutableMap.builder();
        for (Map.Entry input : inputs.expand().entrySet()) {
            PCollection pCollection = (PCollection)input.getValue();
            tables.put((Object)((TupleTag)input.getKey()).getId(), new BeamPCollectionTable(pCollection));
        }
        return tables.build();
    }

    private void registerFunctions(@UnknownKeyFor @NonNull @Initialized BeamSqlEnv.BeamSqlEnvBuilder sqlEnvBuilder) {
        this.udfDefinitions().forEach(udf -> sqlEnvBuilder.addUdf(udf.udfName(), udf.clazz(), udf.methodName()));
        this.udafDefinitions().forEach(udaf -> sqlEnvBuilder.addUdaf(udaf.udafName(), udaf.combineFn()));
    }

    public static @UnknownKeyFor @NonNull @Initialized SqlTransform query(@UnknownKeyFor @NonNull @Initialized String queryString) {
        return SqlTransform.builder().setQueryString(queryString).setQueryParameters(QueryPlanner.QueryParameters.ofNone()).setUdafDefinitions(Collections.emptyList()).setUdfDefinitions(Collections.emptyList()).setTableProviderMap(Collections.emptyMap()).setAutoUdfUdafLoad(false).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTransform withTableProvider(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
        HashMap<String, TableProvider> map = new HashMap<String, TableProvider>(this.tableProviderMap());
        map.put(name, tableProvider);
        return this.toBuilder().setTableProviderMap((Map<String, TableProvider>)ImmutableMap.copyOf(map)).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTransform withDefaultTableProvider(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
        return this.withTableProvider(name, tableProvider).toBuilder().setDefaultTableProvider(name).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTransform withQueryPlannerClass(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized QueryPlanner> clazz) {
        return this.toBuilder().setQueryPlannerClassName(clazz.getName()).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTransform withNamedParameters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> parameters) {
        return this.toBuilder().setQueryParameters(QueryPlanner.QueryParameters.ofNamed(parameters)).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTransform withPositionalParameters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> parameters) {
        return this.toBuilder().setQueryParameters(QueryPlanner.QueryParameters.ofPositional(parameters)).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTransform withAutoUdfUdafLoad(@UnknownKeyFor @NonNull @Initialized boolean autoUdfUdafLoad) {
        return this.toBuilder().setAutoUdfUdafLoad(autoUdfUdafLoad).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTransform registerUdf(@UnknownKeyFor @NonNull @Initialized String functionName, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BeamSqlUdf> clazz) {
        return this.registerUdf(functionName, clazz, "eval");
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTransform registerUdf(@UnknownKeyFor @NonNull @Initialized String functionName, @UnknownKeyFor @NonNull @Initialized SerializableFunction sfn) {
        return this.registerUdf(functionName, sfn.getClass(), "apply");
    }

    private @UnknownKeyFor @NonNull @Initialized SqlTransform registerUdf(@UnknownKeyFor @NonNull @Initialized String functionName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized String method) {
        ImmutableList newUdfDefinitions = ImmutableList.builder().addAll(this.udfDefinitions()).add((Object)UdfDefinition.of(functionName, clazz, method)).build();
        return this.toBuilder().setUdfDefinitions((List<UdfDefinition>)newUdfDefinitions).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTransform registerUdaf(@UnknownKeyFor @NonNull @Initialized String functionName, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn combineFn) {
        ImmutableList newUdafs = ImmutableList.builder().addAll(this.udafDefinitions()).add((Object)UdafDefinition.of(functionName, combineFn)).build();
        return this.toBuilder().setUdafDefinitions((List<UdafDefinition>)newUdafs).build();
    }

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_SqlTransform.Builder();
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    static abstract class UdafDefinition {
        UdafDefinition() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized String udafName();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn combineFn();

        static @UnknownKeyFor @NonNull @Initialized UdafDefinition of(@UnknownKeyFor @NonNull @Initialized String udafName, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn combineFn) {
            return new AutoValue_SqlTransform_UdafDefinition(udafName, combineFn);
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    static abstract class UdfDefinition {
        UdfDefinition() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized String udfName();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz();

        abstract @UnknownKeyFor @NonNull @Initialized String methodName();

        static @UnknownKeyFor @NonNull @Initialized UdfDefinition of(@UnknownKeyFor @NonNull @Initialized String udfName, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized String methodName) {
            return new AutoValue_SqlTransform_UdfDefinition(udfName, clazz, methodName);
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setQueryString(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setQueryParameters(@UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setUdfDefinitions(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized UdfDefinition> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setUdafDefinitions(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized UdafDefinition> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setAutoUdfUdafLoad(@UnknownKeyFor @NonNull @Initialized boolean var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTableProviderMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setDefaultTableProvider(@Nullable @UnknownKeyFor @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setQueryPlannerClassName(@Nullable @UnknownKeyFor @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized SqlTransform build();
    }
}

