/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Set;
import org.apache.beam.sdk.extensions.sql.BeamSqlSeekableTable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamJoinRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamJoinTransforms;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Join;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamSideInputLookupJoinRel
extends BeamJoinRel {
    public BeamSideInputLookupJoinRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode left, @UnknownKeyFor @NonNull @Initialized RelNode right, @UnknownKeyFor @NonNull @Initialized RexNode condition, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized CorrelationId> variablesSet, @UnknownKeyFor @NonNull @Initialized JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        if (this.joinType == JoinRelType.FULL) {
            throw new UnsupportedOperationException("FULL OUTER JOIN is not supported when join a Seekable table with a non Seekable table.");
        }
        if (this.joinType == JoinRelType.LEFT && (Integer)this.seekableInputIndex().get() == 0 || this.joinType == JoinRelType.RIGHT && (Integer)this.seekableInputIndex().get() == 1) {
            throw new UnsupportedOperationException(String.format("%s side of an OUTER JOIN must be a non Seekable table.", this.joinType.name()));
        }
        return new SideInputLookupJoin();
    }

    public @UnknownKeyFor @NonNull @Initialized Join copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RexNode conditionExpr, @UnknownKeyFor @NonNull @Initialized RelNode left, @UnknownKeyFor @NonNull @Initialized RelNode right, @UnknownKeyFor @NonNull @Initialized JoinRelType joinType, @UnknownKeyFor @NonNull @Initialized boolean semiJoinDone) {
        return new BeamSideInputLookupJoinRel(this.getCluster(), traitSet, left, right, conditionExpr, (Set<CorrelationId>)this.variablesSet, joinType);
    }

    private class SideInputLookupJoin
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private SideInputLookupJoin() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            Schema schema = CalciteUtils.toSchema(BeamSideInputLookupJoinRel.this.getRowType());
            BeamRelNode seekableRel = BeamSqlRelUtils.getBeamRelInput(BeamSideInputLookupJoinRel.this.getInput((Integer)BeamSideInputLookupJoinRel.this.seekableInputIndex().get()));
            BeamRelNode nonSeekableRel = BeamSqlRelUtils.getBeamRelInput(BeamSideInputLookupJoinRel.this.getInput((Integer)BeamSideInputLookupJoinRel.this.nonSeekableInputIndex().get()));
            int factColOffset = (Integer)BeamSideInputLookupJoinRel.this.nonSeekableInputIndex().get() == 0 ? 0 : CalciteUtils.toSchema(seekableRel.getRowType()).getFieldCount();
            int lkpColOffset = (Integer)BeamSideInputLookupJoinRel.this.seekableInputIndex().get() == 0 ? 0 : CalciteUtils.toSchema(nonSeekableRel.getRowType()).getFieldCount();
            BeamIOSourceRel seekableInput = (BeamIOSourceRel)seekableRel;
            BeamSqlSeekableTable seekableTable = (BeamSqlSeekableTable)((Object)seekableInput.getBeamSqlTable());
            PCollection nonSeekableInput = pinput.get(0);
            return ((PCollection)nonSeekableInput.apply("join_as_lookup", (PTransform)new BeamJoinTransforms.JoinAsLookup(BeamSideInputLookupJoinRel.this.condition, seekableTable, CalciteUtils.toSchema(seekableInput.getRowType()), schema, factColOffset, lkpColOffset))).setRowSchema(schema);
        }
    }
}

