/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamJoinRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamJoinTransforms;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Join;
import org.apache.beam.sdk.schemas.transforms.Select;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.Pair;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class BeamCoGBKJoinRel
extends BeamJoinRel {
    public BeamCoGBKJoinRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode left, @UnknownKeyFor @NonNull @Initialized RelNode right, @UnknownKeyFor @NonNull @Initialized RexNode condition, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized CorrelationId> variablesSet, @UnknownKeyFor @NonNull @Initialized JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new StandardJoin();
    }

    private <T> void verifySupportedTrigger(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection) {
        WindowingStrategy windowingStrategy = pCollection.getWindowingStrategy();
        if (PCollection.IsBounded.UNBOUNDED.equals((Object)pCollection.isBounded()) && !this.triggersOncePerWindow(windowingStrategy)) {
            throw new UnsupportedOperationException("Joining unbounded PCollections is currently only supported for non-global windows with triggers that are known to produce output once per window,such as the default trigger with zero allowed lateness. In these cases Beam can guarantee it joins all input elements once per window. " + windowingStrategy + " is not supported");
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean triggersOncePerWindow(@UnknownKeyFor @NonNull @Initialized WindowingStrategy windowingStrategy) {
        Trigger trigger = windowingStrategy.getTrigger();
        return !(windowingStrategy.getWindowFn() instanceof GlobalWindows) && trigger instanceof DefaultTrigger && Duration.ZERO.equals((Object)windowingStrategy.getAllowedLateness());
    }

    private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> standardJoin(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> leftRows, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> rightRows, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor leftKeys, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor rightKeys) {
        PCollection joinedRows = null;
        switch (this.joinType) {
            case LEFT: {
                joinedRows = (PCollection)leftRows.apply((PTransform)Join.leftOuterJoin(rightRows).on(Join.FieldsEqual.left((FieldAccessDescriptor)leftKeys).right(rightKeys)));
                break;
            }
            case RIGHT: {
                joinedRows = (PCollection)leftRows.apply((PTransform)Join.rightOuterJoin(rightRows).on(Join.FieldsEqual.left((FieldAccessDescriptor)leftKeys).right(rightKeys)));
                break;
            }
            case FULL: {
                joinedRows = (PCollection)leftRows.apply((PTransform)Join.fullOuterJoin(rightRows).on(Join.FieldsEqual.left((FieldAccessDescriptor)leftKeys).right(rightKeys)));
                break;
            }
            default: {
                joinedRows = (PCollection)leftRows.apply((PTransform)Join.innerJoin(rightRows).on(Join.FieldsEqual.left((FieldAccessDescriptor)leftKeys).right(rightKeys)));
            }
        }
        return (PCollection)joinedRows.apply((PTransform)Select.fieldNames((String[])new String[]{"lhs.*", "rhs.*"}).withOutputSchema(CalciteUtils.toSchema(this.getRowType())));
    }

    public @UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Join copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RexNode conditionExpr, @UnknownKeyFor @NonNull @Initialized RelNode left, @UnknownKeyFor @NonNull @Initialized RelNode right, @UnknownKeyFor @NonNull @Initialized JoinRelType joinType, @UnknownKeyFor @NonNull @Initialized boolean semiJoinDone) {
        return new BeamCoGBKJoinRel(this.getCluster(), traitSet, left, right, conditionExpr, (Set<CorrelationId>)this.variablesSet, joinType);
    }

    private class StandardJoin
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private StandardJoin() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            Schema leftSchema = pinput.get(0).getSchema();
            Schema rightSchema = pinput.get(1).getSchema();
            PCollection leftRows = (PCollection)pinput.get(0).apply("left_TimestampCombiner", (PTransform)Window.configure().withTimestampCombiner(TimestampCombiner.EARLIEST));
            PCollection rightRows = (PCollection)pinput.get(1).apply("right_TimestampCombiner", (PTransform)Window.configure().withTimestampCombiner(TimestampCombiner.EARLIEST));
            List<Pair<RexNode, RexNode>> pairs = BeamJoinRel.extractJoinRexNodes(BeamCoGBKJoinRel.this.condition);
            int leftRowColumnCount = BeamSqlRelUtils.getBeamRelInput(BeamCoGBKJoinRel.this.left).getRowType().getFieldCount();
            FieldAccessDescriptor leftKeyFields = BeamJoinTransforms.getJoinColumns(true, pairs, 0, leftSchema);
            FieldAccessDescriptor rightKeyFields = BeamJoinTransforms.getJoinColumns(false, pairs, leftRowColumnCount, rightSchema);
            WindowFn leftWinFn = leftRows.getWindowingStrategy().getWindowFn();
            WindowFn rightWinFn = rightRows.getWindowingStrategy().getWindowFn();
            try {
                leftWinFn.verifyCompatibility(rightWinFn);
            }
            catch (IncompatibleWindowException e) {
                throw new IllegalArgumentException("WindowFns must match for a bounded-vs-bounded/unbounded-vs-unbounded join.", e);
            }
            BeamCoGBKJoinRel.this.verifySupportedTrigger(leftRows);
            BeamCoGBKJoinRel.this.verifySupportedTrigger(rightRows);
            return BeamCoGBKJoinRel.this.standardJoin((PCollection<Row>)leftRows, (PCollection<Row>)rightRows, leftKeyFields, rightKeyFields);
        }
    }
}

