/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamPushDownIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.TableScan;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;

public class BeamIOSourceRel
extends TableScan
implements BeamRelNode {
    public static final double CONSTANT_WINDOW_SIZE = 10.0;
    private final BeamSqlTable beamTable;
    private final BeamCalciteTable calciteTable;
    private final Map<String, String> pipelineOptions;

    public BeamIOSourceRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, BeamSqlTable beamTable, Map<String, String> pipelineOptions, BeamCalciteTable calciteTable) {
        super(cluster, traitSet, table);
        this.beamTable = beamTable;
        this.calciteTable = calciteTable;
        this.pipelineOptions = pipelineOptions;
    }

    public BeamPushDownIOSourceRel createPushDownRel(RelDataType newType, List<String> usedFields, BeamSqlTableFilter tableFilters) {
        RelOptTable relOptTable = newType == null ? this.table : ((RelOptTableImpl)this.getTable()).copy(newType);
        return new BeamPushDownIOSourceRel(this.getCluster(), this.traitSet, relOptTable, this.beamTable, usedFields, tableFilters, this.pipelineOptions, this.calciteTable);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        BeamTableStatistics rowCountStatistics = this.calciteTable.getStatistic();
        if (this.beamTable.isBounded() == PCollection.IsBounded.BOUNDED) {
            return rowCountStatistics.getRowCount();
        }
        return rowCountStatistics.getRate();
    }

    @Override
    public NodeStats estimateNodeStats(RelMetadataQuery mq) {
        BeamTableStatistics rowCountStatistics = this.calciteTable.getStatistic();
        double window = this.beamTable.isBounded() == PCollection.IsBounded.BOUNDED ? rowCountStatistics.getRowCount() : 10.0;
        return NodeStats.create(rowCountStatistics.getRowCount(), rowCountStatistics.getRate(), window);
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return this.beamTable.isBounded();
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = this.estimateRowCount(mq);
        return planner.getCostFactory().makeCost(rowCount, rowCount, rowCount);
    }

    @Override
    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        NodeStats estimates = BeamSqlRelUtils.getNodeStats(this, mq);
        return BeamCostModel.FACTORY.makeCost(estimates.getRowCount(), estimates.getRate());
    }

    public BeamSqlTable getBeamSqlTable() {
        return this.beamTable;
    }

    @Override
    public Map<String, String> getPipelineOptions() {
        return this.pipelineOptions;
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> input) {
            Preconditions.checkArgument((input.size() == 0 ? 1 : 0) != 0, (String)"Should not have received input for %s: %s", (Object[])new Object[]{BeamIOSourceRel.class.getSimpleName(), input});
            return BeamIOSourceRel.this.beamTable.buildIOReader(input.getPipeline().begin());
        }
    }
}

