/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex;

import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexBiVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;

public class RexFieldAccess
extends RexNode {
    private final RexNode expr;
    private final RelDataTypeField field;

    RexFieldAccess(RexNode expr, RelDataTypeField field) {
        this.expr = expr;
        this.field = field;
        this.digest = expr + "." + field.getName();
        assert (expr.getType().getFieldList().get(field.getIndex()) == field);
    }

    public RelDataTypeField getField() {
        return this.field;
    }

    @Override
    public RelDataType getType() {
        return this.field.getType();
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.FIELD_ACCESS;
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitFieldAccess(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitFieldAccess(this, arg);
    }

    public RexNode getReferenceExpr() {
        return this.expr;
    }
}

