/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema.text;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.commons.csv.CSVFormat;

public class BeamTextCSVTableIOWriter
extends PTransform<PCollection<BeamRecord>, PDone>
implements Serializable {
    private String filePattern;
    protected BeamRecordSqlType beamSqlRowType;
    protected CSVFormat csvFormat;

    public BeamTextCSVTableIOWriter(BeamRecordSqlType beamSqlRowType, String filePattern, CSVFormat csvFormat) {
        this.filePattern = filePattern;
        this.beamSqlRowType = beamSqlRowType;
        this.csvFormat = csvFormat;
    }

    public PDone expand(PCollection<BeamRecord> input) {
        return (PDone)((PCollection)input.apply("encodeRecord", (PTransform)ParDo.of((DoFn)new DoFn<BeamRecord, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctx) {
                BeamRecord row = (BeamRecord)ctx.element();
                ctx.output((Object)BeamTableUtils.beamSqlRow2CsvLine(row, BeamTextCSVTableIOWriter.this.csvFormat));
            }
        }))).apply((PTransform)TextIO.write().to(this.filePattern));
    }
}

