/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlReinterpretExpression
extends BeamSqlExpression {
    public BeamSqlReinterpretExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    @Override
    public boolean accept() {
        return this.getOperands().size() == 1 && this.outputType == SqlTypeName.BIGINT && SqlTypeName.DATETIME_TYPES.contains((Object)this.opType(0));
    }

    @Override
    public BeamSqlPrimitive evaluate(BeamRecord inputRow, BoundedWindow window) {
        if (this.opType(0) == SqlTypeName.TIME) {
            GregorianCalendar date = (GregorianCalendar)this.opValueEvaluated(0, inputRow, window);
            return BeamSqlPrimitive.of(this.outputType, date.getTimeInMillis());
        }
        Date date = (Date)this.opValueEvaluated(0, inputRow, window);
        return BeamSqlPrimitive.of(this.outputType, date.getTime());
    }
}

