/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptUtil;

@Experimental
public class BeamSqlCli {
    public static String explainQuery(String sqlString, BeamSqlEnv sqlEnv) throws Exception {
        BeamRelNode exeTree = sqlEnv.getPlanner().convertToBeamRel(sqlString);
        String beamPlan = RelOptUtil.toString(exeTree);
        return beamPlan;
    }

    public static PCollection<BeamRecord> compilePipeline(String sqlStatement, BeamSqlEnv sqlEnv) throws Exception {
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])new String[0]).withValidation().as(PipelineOptions.class);
        options.setJobName("BeamPlanCreator");
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        return BeamSqlCli.compilePipeline(sqlStatement, pipeline, sqlEnv);
    }

    public static PCollection<BeamRecord> compilePipeline(String sqlStatement, Pipeline basePipeline, BeamSqlEnv sqlEnv) throws Exception {
        PCollection<BeamRecord> resultStream = sqlEnv.getPlanner().compileBeamPipeline(sqlStatement, basePipeline, sqlEnv);
        return resultStream;
    }
}

