/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.tuple.Pair;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

public class BigQueryFilter
implements BeamSqlTableFilter {
    private static final ImmutableSet<SqlKind> SUPPORTED_OPS = ImmutableSet.builder().add((Object[])SqlKind.COMPARISON.toArray(new SqlKind[0])).add((Object[])new SqlKind[]{SqlKind.PLUS, SqlKind.MINUS, SqlKind.MOD, SqlKind.DIVIDE, SqlKind.TIMES, SqlKind.LIKE, SqlKind.BETWEEN, SqlKind.CAST, SqlKind.AND, SqlKind.OR}).build();
    private List<RexNode> supported = new ArrayList<RexNode>();
    private List<RexNode> unsupported = new ArrayList<RexNode>();

    public BigQueryFilter(List<RexNode> predicateCNF) {
        for (RexNode node : predicateCNF) {
            if (!node.getType().getSqlTypeName().equals((Object)SqlTypeName.BOOLEAN)) {
                throw new RuntimeException("Predicate node '" + node.getClass().getSimpleName() + "' should be a boolean expression, but was: " + node.getType().getSqlTypeName());
            }
            if (((Boolean)this.isSupported(node).getLeft()).booleanValue()) {
                this.supported.add(node);
                continue;
            }
            this.unsupported.add(node);
        }
    }

    @Override
    public List<RexNode> getNotSupported() {
        return this.unsupported;
    }

    public List<RexNode> getSupported() {
        return this.supported;
    }

    public String toString() {
        String supStr = "supported{" + this.supported.stream().map(RexNode::toString).collect(Collectors.joining()) + "}";
        String unsupStr = "unsupported{" + this.unsupported.stream().map(RexNode::toString).collect(Collectors.joining()) + "}";
        return "[" + supStr + ", " + unsupStr + "]";
    }

    private Pair<Boolean, Integer> isSupported(RexNode node) {
        int numberOfInputRefs = 0;
        boolean isSupported = true;
        if (node instanceof RexCall) {
            RexCall compositeNode = (RexCall)node;
            if (!node.getKind().belongsTo(SUPPORTED_OPS)) {
                isSupported = false;
            } else {
                for (RexNode operand : compositeNode.getOperands()) {
                    Pair<Boolean, Integer> childSupported = this.isSupported(operand);
                    if (!node.getKind().belongsTo((Collection)ImmutableSet.of((Object)SqlKind.AND, (Object)SqlKind.OR))) {
                        numberOfInputRefs += ((Integer)childSupported.getRight()).intValue();
                    }
                    isSupported = numberOfInputRefs < 2 && (Boolean)childSupported.getLeft() != false;
                }
            }
        } else if (node instanceof RexInputRef) {
            numberOfInputRefs = 1;
        } else if (!(node instanceof RexLiteral)) {
            throw new RuntimeException("Encountered an unexpected node type: " + node.getClass().getSimpleName());
        }
        return Pair.of((Object)isSupported, (Object)numberOfInputRefs);
    }
}

