/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.Casing;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.config.NullCollation;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlSetOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlSyntax;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.dialect.BigQuerySqlDialect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.BasicSqlType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class BeamBigQuerySqlDialect
extends BigQuerySqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.BIG_QUERY).withIdentifierQuoteString("`").withNullCollation(NullCollation.LOW).withUnquotedCasing(Casing.UNCHANGED).withQuotedCasing(Casing.UNCHANGED).withCaseSensitive(false);
    public static final SqlDialect DEFAULT = new BeamBigQuerySqlDialect(DEFAULT_CONTEXT);
    private static final Pattern IDENTIFIER_REGEX = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    private static final SqlOperator UNION_DISTINCT = new SqlSetOperator("UNION DISTINCT", SqlKind.UNION, 14, false);
    private static final SqlSetOperator EXCEPT_DISTINCT = new SqlSetOperator("EXCEPT DISTINCT", SqlKind.EXCEPT, 14, false);
    private static final SqlSetOperator INTERSECT_DISTINCT = new SqlSetOperator("INTERSECT DISTINCT", SqlKind.INTERSECT, 18, false);
    private static final List<String> RESERVED_KEYWORDS = ImmutableList.copyOf(Arrays.asList("ALL", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERT_ROWS_MODIFIED", "AT", "BETWEEN", "BY", "CASE", "CAST", "COLLATE", "CONTAINS", "CREATE", "CROSS", "CUBE", "CURRENT", "DEFAULT", "DEFINE", "DESC", "DISTINCT", "ELSE", "END", "ENUM", "ESCAPE", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", "FALSE", "FETCH", "FOLLOWING", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "GROUPS", "HASH", "HAVING", "IF", "IGNORE", "IN", "INNER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LIMIT", "LOOKUP", "MERGE", "NATURAL", "NEW", "NO", "NOT", "NULL", "NULLS", "OF", "ON", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PRECEDING", "PROTO", "RANGE", "RECURSIVE", "RESPECT", "RIGHT", "ROLLUP", "ROWS", "SELECT", "SET", "SOME", "STRUCT", "TABLESAMPLE", "THEN", "TO", "TREAT", "TRUE", "UNBOUNDED", "UNION", "UNNEST", "USING", "WHEN", "WHERE", "WINDOW", "WITH", "WITHIN"));

    public BeamBigQuerySqlDialect(SqlDialect.Context context) {
        super(context);
    }

    public String quoteIdentifier(String val) {
        return this.quoteIdentifier(new StringBuilder(), val).toString();
    }

    public SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
    }

    public void unparseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        this.unparseFetchUsingLimit(writer, offset, fetch);
    }

    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("STRPOS");
                writer.sep(",");
                call.operand(1).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                call.operand(0).unparse(writer, leftPrec, rightPrec);
                if (3 == call.operandCount()) {
                    throw new RuntimeException("3rd operand Not Supported for Function STRPOS in Big Query");
                }
                writer.endFunCall(frame);
                break;
            }
            case UNION: {
                if (((SqlSetOperator)call.getOperator()).isAll()) break;
                SqlSyntax.BINARY.unparse(writer, UNION_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            case EXCEPT: {
                if (((SqlSetOperator)call.getOperator()).isAll()) break;
                SqlSyntax.BINARY.unparse(writer, (SqlOperator)EXCEPT_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            case INTERSECT: {
                if (((SqlSetOperator)call.getOperator()).isAll()) break;
                SqlSyntax.BINARY.unparse(writer, (SqlOperator)INTERSECT_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    public SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            switch (type.getSqlTypeName()) {
                case BIGINT: 
                case INTEGER: 
                case TINYINT: 
                case SMALLINT: {
                    return BeamBigQuerySqlDialect.typeFromName(type, "INT64");
                }
                case FLOAT: 
                case DOUBLE: {
                    return BeamBigQuerySqlDialect.typeFromName(type, "FLOAT64");
                }
                case DECIMAL: {
                    return BeamBigQuerySqlDialect.typeFromName(type, "NUMERIC");
                }
                case BOOLEAN: {
                    return BeamBigQuerySqlDialect.typeFromName(type, "BOOL");
                }
                case CHAR: 
                case VARCHAR: {
                    return BeamBigQuerySqlDialect.typeFromName(type, "STRING");
                }
                case VARBINARY: 
                case BINARY: {
                    return BeamBigQuerySqlDialect.typeFromName(type, "BYTES");
                }
                case DATE: {
                    return BeamBigQuerySqlDialect.typeFromName(type, "DATE");
                }
                case TIME: {
                    return BeamBigQuerySqlDialect.typeFromName(type, "TIME");
                }
                case TIMESTAMP: {
                    return BeamBigQuerySqlDialect.typeFromName(type, "TIMESTAMP");
                }
            }
        }
        return super.getCastSpec(type);
    }

    private static SqlNode typeFromName(RelDataType type, String name) {
        return new SqlDataTypeSpec(new SqlIdentifier(name, SqlParserPos.ZERO), type.getPrecision(), -1, null, null, SqlParserPos.ZERO);
    }
}

