/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.util.Iterator;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSetOperatorRelBase;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.Iterators;

public abstract class BeamSetOperatorsTransforms {

    public static class SetOperatorFilteringDoFn
    extends DoFn<KV<Row, CoGbkResult>, Row> {
        private TupleTag<Row> leftTag;
        private TupleTag<Row> rightTag;
        private BeamSetOperatorRelBase.OpType opType;
        private boolean all;

        public SetOperatorFilteringDoFn(TupleTag<Row> leftTag, TupleTag<Row> rightTag, BeamSetOperatorRelBase.OpType opType, boolean all) {
            this.leftTag = leftTag;
            this.rightTag = rightTag;
            this.opType = opType;
            this.all = all;
        }

        /*
         * Enabled aggressive block sorting
         */
        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext ctx) {
            CoGbkResult coGbkResult = (CoGbkResult)((KV)ctx.element()).getValue();
            Iterable leftRows = coGbkResult.getAll(this.leftTag);
            Iterable rightRows = coGbkResult.getAll(this.rightTag);
            switch (this.opType) {
                case UNION: {
                    if (!this.all) {
                        ctx.output((Object)((Row)((KV)ctx.element()).getKey()));
                        return;
                    }
                    Iterator iter = leftRows.iterator();
                    while (iter.hasNext()) {
                        ctx.output((Object)((Row)iter.next()));
                    }
                    iter = rightRows.iterator();
                    while (iter.hasNext()) {
                        ctx.output((Object)((Row)iter.next()));
                    }
                    return;
                }
                case INTERSECT: {
                    int rightCount;
                    if (!leftRows.iterator().hasNext()) return;
                    if (!rightRows.iterator().hasNext()) return;
                    if (!this.all) {
                        ctx.output((Object)((Row)((KV)ctx.element()).getKey()));
                        return;
                    }
                    int leftCount = Iterators.size(leftRows.iterator());
                    Iterator iter = leftCount <= (rightCount = Iterators.size(rightRows.iterator())) ? leftRows.iterator() : rightRows.iterator();
                    while (iter.hasNext()) {
                        ctx.output((Object)((Row)iter.next()));
                    }
                    return;
                }
                case MINUS: {
                    int rightCount;
                    if (leftRows.iterator().hasNext() && !rightRows.iterator().hasNext()) {
                        Iterator iter = leftRows.iterator();
                        if (this.all) {
                            while (iter.hasNext()) {
                                ctx.output((Object)((Row)iter.next()));
                            }
                            return;
                        }
                        ctx.output((Object)((Row)iter.next()));
                        return;
                    }
                    if (!leftRows.iterator().hasNext()) return;
                    if (!rightRows.iterator().hasNext()) return;
                    int leftCount = Iterators.size(leftRows.iterator());
                    int outputCount = leftCount - (rightCount = Iterators.size(rightRows.iterator()));
                    if (outputCount <= 0) return;
                    if (!this.all) return;
                    while (outputCount > 0) {
                        --outputCount;
                        ctx.output((Object)((Row)((KV)ctx.element()).getKey()));
                    }
                    return;
                }
            }
        }
    }

    public static class BeamSqlRow2KvFn
    extends SimpleFunction<Row, KV<Row, Row>> {
        public KV<Row, Row> apply(Row input) {
            return KV.of((Object)input, (Object)input);
        }
    }
}

