/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.pubsub;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.AutoValue_PubsubIOJsonTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubMessageToRow;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTagList;

@AutoValue
@Internal
@Experimental
abstract class PubsubIOJsonTable
extends BaseBeamTable
implements Serializable {
    PubsubIOJsonTable() {
    }

    @Nullable
    abstract String getTimestampAttribute();

    @Nullable
    abstract String getDeadLetterQueue();

    private boolean useDlq() {
        return this.getDeadLetterQueue() != null;
    }

    abstract String getTopic();

    static Builder builder() {
        return new AutoValue_PubsubIOJsonTable.Builder();
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    @Override
    public abstract Schema getSchema();

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        PCollectionTuple rowsWithDlq = (PCollectionTuple)((PCollection)begin.apply("readFromPubsub", this.readMessagesWithAttributes())).apply("parseMessageToRow", this.createParserParDo());
        rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG).setRowSchema(this.getSchema());
        if (this.useDlq()) {
            rowsWithDlq.get(PubsubMessageToRow.DLQ_TAG).apply(this.writeMessagesToDlq());
        }
        return rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG);
    }

    private ParDo.MultiOutput<PubsubMessage, Row> createParserParDo() {
        return ParDo.of((DoFn)PubsubMessageToRow.builder().messageSchema(this.getSchema()).useDlq(this.getDeadLetterQueue() != null).build()).withOutputTags(PubsubMessageToRow.MAIN_TAG, this.useDlq() ? TupleTagList.of(PubsubMessageToRow.DLQ_TAG) : TupleTagList.empty());
    }

    private PubsubIO.Read<PubsubMessage> readMessagesWithAttributes() {
        PubsubIO.Read read = PubsubIO.readMessagesWithAttributes().fromTopic(this.getTopic());
        return this.getTimestampAttribute() == null ? read : read.withTimestampAttribute(this.getTimestampAttribute());
    }

    private PubsubIO.Write<PubsubMessage> writeMessagesToDlq() {
        PubsubIO.Write write = PubsubIO.writeMessages().to(this.getDeadLetterQueue());
        return this.getTimestampAttribute() == null ? write : write.withTimestampAttribute(this.getTimestampAttribute());
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        throw new UnsupportedOperationException("Writing to a Pubsub topic is not supported");
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        return BeamTableStatistics.UNBOUNDED_UNKNOWN;
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setSchema(Schema var1);

        abstract Builder setTimestampAttribute(String var1);

        abstract Builder setDeadLetterQueue(String var1);

        abstract Builder setTopic(String var1);

        abstract PubsubIOJsonTable build();
    }
}

