/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.List;
import org.apache.beam.repackaged.sql.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.repackaged.sql.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlDrop;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Static;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

abstract class SqlDropObject
extends SqlDrop
implements SqlExecutableStatement {
    protected final SqlIdentifier name;

    SqlDropObject(SqlOperator operator, SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        super(operator, pos, ifExists);
        this.name = name;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        List<String> path = context.getDefaultSchemaPath();
        CalciteSchema schema = context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        switch (this.getKind()) {
            case DROP_TABLE: {
                boolean existed;
                if (schema.schema instanceof BeamCalciteSchema) {
                    BeamCalciteSchema beamSchema = (BeamCalciteSchema)schema.schema;
                    beamSchema.getTableProvider().dropTable(this.name.getSimple());
                    existed = true;
                } else {
                    existed = schema.removeTable(this.name.getSimple());
                }
                if (existed || this.ifExists) break;
                throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.tableNotFound(this.name.getSimple()));
            }
            default: {
                throw new AssertionError((Object)this.getKind());
            }
        }
    }
}

