/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.ReflectiveCallNotNullImplementor;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.repackaged.sql.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.function.SemiStrict;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.function.Strict;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.Function;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.ImplementableFunction;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.ScalarFunction;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Static;
import org.apache.beam.sdk.extensions.sql.impl.UdfImplReflectiveFunctionBase;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMultimap;

public class ScalarFunctionImpl
extends UdfImplReflectiveFunctionBase
implements ScalarFunction,
ImplementableFunction {
    private final CallImplementor implementor;

    private ScalarFunctionImpl(Method method, CallImplementor implementor) {
        super(method);
        this.implementor = implementor;
    }

    public static ImmutableMultimap<String, Function> createAll(Class<?> clazz) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class || !Modifier.isStatic(method.getModifiers()) && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz)) continue;
            Function function = ScalarFunctionImpl.create(method);
            builder.put((Object)method.getName(), (Object)function);
        }
        return builder.build();
    }

    public static Function create(Class<?> clazz, String methodName) {
        Method method = ScalarFunctionImpl.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        return ScalarFunctionImpl.create(method);
    }

    public static Function create(Method method) {
        Class<?> clazz;
        if (!Modifier.isStatic(method.getModifiers()) && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz = method.getDeclaringClass())) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        if (method.getExceptionTypes().length != 0) {
            throw new RuntimeException(method.getName() + " must not throw checked exception");
        }
        CallImplementor implementor = ScalarFunctionImpl.createImplementor(method);
        return new ScalarFunctionImpl(method, implementor);
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return CalciteUtils.sqlTypeWithAutoCast(typeFactory, this.method.getReturnType());
    }

    @Override
    public CallImplementor getImplementor() {
        return this.implementor;
    }

    private static CallImplementor createImplementor(Method method) {
        NullPolicy nullPolicy = ScalarFunctionImpl.getNullPolicy(method);
        return RexImpTable.createImplementor(new ScalarReflectiveCallNotNullImplementor(method), nullPolicy, false);
    }

    private static NullPolicy getNullPolicy(Method m) {
        if (m.getAnnotation(Strict.class) != null) {
            return NullPolicy.STRICT;
        }
        if (m.getAnnotation(SemiStrict.class) != null) {
            return NullPolicy.SEMI_STRICT;
        }
        if (m.getDeclaringClass().getAnnotation(Strict.class) != null) {
            return NullPolicy.STRICT;
        }
        if (m.getDeclaringClass().getAnnotation(SemiStrict.class) != null) {
            return NullPolicy.SEMI_STRICT;
        }
        return NullPolicy.NONE;
    }

    public RelDataType getReturnType(RelDataTypeFactory typeFactory, SqlOperatorBinding opBinding) {
        RelDataType returnType = this.getReturnType(typeFactory);
        switch (ScalarFunctionImpl.getNullPolicy(this.method)) {
            case STRICT: {
                for (RelDataType type : opBinding.collectOperandTypes()) {
                    if (!type.isNullable()) continue;
                    return typeFactory.createTypeWithNullability(returnType, true);
                }
                break;
            }
            case SEMI_STRICT: {
                return typeFactory.createTypeWithNullability(returnType, true);
            }
        }
        return returnType;
    }

    static boolean classHasPublicZeroArgsConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    static Method findMethod(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || method.isBridge()) continue;
            return method;
        }
        return null;
    }

    private static class ScalarReflectiveCallNotNullImplementor
    extends ReflectiveCallNotNullImplementor {
        ScalarReflectiveCallNotNullImplementor(Method method) {
            super(method);
        }

        private static List<Expression> translate(List<Type> types, List<Expression> expressions) {
            Preconditions.checkArgument((types.size() == expressions.size() ? 1 : 0) != 0, (Object)"types.size() != expressions.size()");
            ArrayList<Expression> translated = new ArrayList<Expression>();
            for (int i = 0; i < expressions.size(); ++i) {
                translated.add(ScalarReflectiveCallNotNullImplementor.translate(types.get(i), expressions.get(i)));
            }
            return translated;
        }

        private static Expression translate(Type type, Expression expression) {
            if (type == byte[].class && expression.type == ByteString.class) {
                return Expressions.condition(Expressions.equal(expression, Expressions.constant(null)), Expressions.constant(null), Expressions.call(expression, "getBytes", new Expression[0]));
            }
            return expression;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            List<Expression> translated = ScalarReflectiveCallNotNullImplementor.translate(Arrays.asList(this.method.getParameterTypes()), translatedOperands);
            return super.implement(translator, call, translated);
        }
    }
}

