/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable;

import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.InvalidRelException;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.JoinInfo;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.SemiJoin;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.BuiltInMethod;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.ImmutableIntList;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Util;

public class EnumerableSemiJoin
extends SemiJoin
implements EnumerableRel {
    EnumerableSemiJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) throws InvalidRelException {
        super(cluster, traits, left, right, condition, leftKeys, rightKeys);
    }

    public static EnumerableSemiJoin create(RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        RelOptCluster cluster = left.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.enumerableSemiJoin(mq, left, right));
        try {
            return new EnumerableSemiJoin(cluster, traitSet, left, right, condition, leftKeys, rightKeys);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public SemiJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (joinType == JoinRelType.INNER);
        JoinInfo joinInfo = JoinInfo.of(left, right, condition);
        assert (joinInfo.isEqui());
        try {
            return new EnumerableSemiJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        double rightRowCount = this.right.estimateRowCount(mq);
        double leftRowCount = this.left.estimateRowCount(mq);
        rowCount = Double.isInfinite(leftRowCount) ? leftRowCount : (rowCount += Util.nLogN(leftRowCount));
        rowCount = Double.isInfinite(rightRowCount) ? rightRowCount : (rowCount += rightRowCount);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0).multiplyBy(0.01);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = leftResult.physType;
        return implementor.result(physType, builder.append(Expressions.call(BuiltInMethod.SEMI_JOIN.method, Expressions.list(leftExpression, rightExpression, leftResult.physType.generateAccessor(this.leftKeys), rightResult.physType.generateAccessor(this.rightKeys)))).toBlock());
    }
}

