/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.beam.repackaged.sql.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.schemas.LogicalTypes;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.joda.time.Instant;
import org.joda.time.base.AbstractInstant;

public class CalciteUtils {
    private static final long UNLIMITED_ARRAY_SIZE = -1L;
    public static final Schema.FieldType TINY_INT = Schema.FieldType.BYTE;
    public static final Schema.FieldType SMALL_INT = Schema.FieldType.INT16;
    public static final Schema.FieldType INTEGER = Schema.FieldType.INT32;
    public static final Schema.FieldType BIG_INT = Schema.FieldType.INT64;
    public static final Schema.FieldType FLOAT = Schema.FieldType.FLOAT;
    public static final Schema.FieldType DOUBLE = Schema.FieldType.DOUBLE;
    public static final Schema.FieldType DECIMAL = Schema.FieldType.DECIMAL;
    public static final Schema.FieldType BOOLEAN = Schema.FieldType.BOOLEAN;
    public static final Schema.FieldType VARBINARY = Schema.FieldType.BYTES;
    public static final Schema.FieldType VARCHAR = Schema.FieldType.STRING;
    public static final Schema.FieldType CHAR = Schema.FieldType.logicalType((Schema.LogicalType)new CharType());
    public static final Schema.FieldType DATE = Schema.FieldType.logicalType((Schema.LogicalType)new DateType());
    public static final Schema.FieldType TIME = Schema.FieldType.logicalType((Schema.LogicalType)new TimeType());
    public static final Schema.FieldType TIME_WITH_LOCAL_TZ = Schema.FieldType.logicalType((Schema.LogicalType)new TimeWithLocalTzType());
    public static final Schema.FieldType TIMESTAMP = Schema.FieldType.DATETIME;
    public static final Schema.FieldType TIMESTAMP_WITH_LOCAL_TZ = Schema.FieldType.logicalType((Schema.LogicalType)new TimestampWithLocalTzType());
    private static final BiMap<Schema.FieldType, SqlTypeName> BEAM_TO_CALCITE_TYPE_MAPPING = ImmutableBiMap.builder().put((Object)TINY_INT, (Object)SqlTypeName.TINYINT).put((Object)SMALL_INT, (Object)SqlTypeName.SMALLINT).put((Object)INTEGER, (Object)SqlTypeName.INTEGER).put((Object)BIG_INT, (Object)SqlTypeName.BIGINT).put((Object)FLOAT, (Object)SqlTypeName.FLOAT).put((Object)DOUBLE, (Object)SqlTypeName.DOUBLE).put((Object)DECIMAL, (Object)SqlTypeName.DECIMAL).put((Object)BOOLEAN, (Object)SqlTypeName.BOOLEAN).put((Object)VARBINARY, (Object)SqlTypeName.VARBINARY).put((Object)VARCHAR, (Object)SqlTypeName.VARCHAR).put((Object)CHAR, (Object)SqlTypeName.CHAR).put((Object)DATE, (Object)SqlTypeName.DATE).put((Object)TIME, (Object)SqlTypeName.TIME).put((Object)TIME_WITH_LOCAL_TZ, (Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE).put((Object)TIMESTAMP, (Object)SqlTypeName.TIMESTAMP).put((Object)TIMESTAMP_WITH_LOCAL_TZ, (Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build();
    private static final ImmutableMap<SqlTypeName, Schema.FieldType> CALCITE_TO_BEAM_TYPE_MAPPING = ImmutableMap.builder().put((Object)SqlTypeName.TINYINT, (Object)TINY_INT).put((Object)SqlTypeName.SMALLINT, (Object)SMALL_INT).put((Object)SqlTypeName.INTEGER, (Object)INTEGER).put((Object)SqlTypeName.BIGINT, (Object)BIG_INT).put((Object)SqlTypeName.FLOAT, (Object)FLOAT).put((Object)SqlTypeName.DOUBLE, (Object)DOUBLE).put((Object)SqlTypeName.DECIMAL, (Object)DECIMAL).put((Object)SqlTypeName.BOOLEAN, (Object)BOOLEAN).put((Object)SqlTypeName.VARBINARY, (Object)VARBINARY).put((Object)SqlTypeName.BINARY, (Object)VARBINARY).put((Object)SqlTypeName.VARCHAR, (Object)VARCHAR).put((Object)SqlTypeName.CHAR, (Object)CHAR).put((Object)SqlTypeName.DATE, (Object)DATE).put((Object)SqlTypeName.TIME, (Object)TIME).put((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, (Object)TIME_WITH_LOCAL_TZ).put((Object)SqlTypeName.TIMESTAMP, (Object)TIMESTAMP).put((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, (Object)TIMESTAMP_WITH_LOCAL_TZ).build();
    private static final Map<Schema.FieldType, SqlTypeName> BEAM_TO_CALCITE_DEFAULT_MAPPING = ImmutableMap.of((Object)Schema.FieldType.DATETIME, (Object)((Object)SqlTypeName.TIMESTAMP), (Object)Schema.FieldType.STRING, (Object)((Object)SqlTypeName.VARCHAR));

    public static boolean isDateTimeType(Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.DATETIME) {
            return true;
        }
        if (fieldType.getTypeName().isLogicalType()) {
            String logicalId = fieldType.getLogicalType().getIdentifier();
            return logicalId.equals("SqlDateType") || logicalId.equals("SqlTimeType") || logicalId.equals("SqlTimeWithLocalTzType") || logicalId.equals("SqlTimestampWithLocalTzType");
        }
        return false;
    }

    public static boolean isStringType(Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.STRING) {
            return true;
        }
        if (fieldType.getTypeName().isLogicalType()) {
            String logicalId = fieldType.getLogicalType().getIdentifier();
            return logicalId.equals("SqlCharType");
        }
        return false;
    }

    public static Schema toSchema(RelDataType tableInfo) {
        return (Schema)tableInfo.getFieldList().stream().map(CalciteUtils::toField).collect(Schema.toSchema());
    }

    public static SqlTypeName toSqlTypeName(Schema.FieldType type) {
        switch (type.getTypeName()) {
            case ROW: {
                return SqlTypeName.ROW;
            }
            case ARRAY: {
                return SqlTypeName.ARRAY;
            }
            case MAP: {
                return SqlTypeName.MAP;
            }
        }
        SqlTypeName typeName = (SqlTypeName)((Object)BEAM_TO_CALCITE_TYPE_MAPPING.get((Object)type.withNullable(false)));
        if (typeName != null) {
            return typeName;
        }
        return BEAM_TO_CALCITE_DEFAULT_MAPPING.get(type);
    }

    public static Schema.FieldType toFieldType(SqlTypeName sqlTypeName) {
        switch (sqlTypeName) {
            case MAP: 
            case MULTISET: 
            case ARRAY: 
            case ROW: {
                throw new IllegalArgumentException(String.format("%s is a type constructor that takes parameters, not a type,so it cannot be converted to a %s", new Object[]{sqlTypeName, Schema.FieldType.class.getSimpleName()}));
            }
        }
        return (Schema.FieldType)CALCITE_TO_BEAM_TYPE_MAPPING.get((Object)sqlTypeName);
    }

    public static Schema.Field toField(RelDataTypeField calciteField) {
        return CalciteUtils.toField(calciteField.getName(), calciteField.getType());
    }

    public static Schema.Field toField(String name, RelDataType calciteType) {
        return Schema.Field.of((String)name, (Schema.FieldType)CalciteUtils.toFieldType(calciteType)).withNullable(calciteType.isNullable());
    }

    public static Schema.FieldType toFieldType(RelDataType calciteType) {
        switch (calciteType.getSqlTypeName()) {
            case MULTISET: 
            case ARRAY: {
                return Schema.FieldType.array((Schema.FieldType)CalciteUtils.toFieldType(calciteType.getComponentType()));
            }
            case MAP: {
                return Schema.FieldType.map((Schema.FieldType)CalciteUtils.toFieldType(calciteType.getKeyType()), (Schema.FieldType)CalciteUtils.toFieldType(calciteType.getValueType()));
            }
            case ROW: {
                return Schema.FieldType.row((Schema)CalciteUtils.toSchema(calciteType));
            }
        }
        return CalciteUtils.toFieldType(calciteType.getSqlTypeName());
    }

    public static RelDataType toCalciteRowType(Schema schema, RelDataTypeFactory dataTypeFactory) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(dataTypeFactory);
        IntStream.range(0, schema.getFieldCount()).forEach(idx -> builder.add(schema.getField(idx).getName(), CalciteUtils.toRelDataType(dataTypeFactory, schema, idx)));
        return builder.build();
    }

    public static RelDataType toRelDataType(RelDataTypeFactory dataTypeFactory, Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ARRAY: {
                return dataTypeFactory.createArrayType(CalciteUtils.toRelDataType(dataTypeFactory, fieldType.getCollectionElementType()), -1L);
            }
            case MAP: {
                RelDataType componentKeyType = CalciteUtils.toRelDataType(dataTypeFactory, fieldType.getMapKeyType());
                RelDataType componentValueType = CalciteUtils.toRelDataType(dataTypeFactory, fieldType.getMapValueType());
                return dataTypeFactory.createMapType(componentKeyType, componentValueType);
            }
            case ROW: {
                return CalciteUtils.toCalciteRowType(fieldType.getRowSchema(), dataTypeFactory);
            }
        }
        return dataTypeFactory.createSqlType(CalciteUtils.toSqlTypeName(fieldType));
    }

    private static RelDataType toRelDataType(RelDataTypeFactory dataTypeFactory, Schema schema, int fieldIndex) {
        Schema.Field field = schema.getField(fieldIndex);
        RelDataType type = CalciteUtils.toRelDataType(dataTypeFactory, field.getType());
        return dataTypeFactory.createTypeWithNullability(type, field.getType().getNullable());
    }

    public static RelDataType sqlTypeWithAutoCast(RelDataTypeFactory typeFactory, Type rawType) {
        if (rawType instanceof Class && AbstractInstant.class.isAssignableFrom((Class)rawType)) {
            return typeFactory.createJavaType(Date.class);
        }
        if (rawType instanceof Class && ByteString.class.isAssignableFrom((Class)rawType)) {
            return typeFactory.createJavaType(byte[].class);
        }
        return typeFactory.createJavaType((Class)rawType);
    }

    public static class CharType
    extends LogicalTypes.PassThroughLogicalType<String> {
        public static final String IDENTIFIER = "SqlCharType";

        public CharType() {
            super(IDENTIFIER, "", Schema.FieldType.STRING);
        }
    }

    public static class TimestampWithLocalTzType
    extends LogicalTypes.PassThroughLogicalType<Instant> {
        public static final String IDENTIFIER = "SqlTimestampWithLocalTzType";

        public TimestampWithLocalTzType() {
            super(IDENTIFIER, "", Schema.FieldType.DATETIME);
        }
    }

    public static class TimeWithLocalTzType
    extends LogicalTypes.PassThroughLogicalType<Instant> {
        public static final String IDENTIFIER = "SqlTimeWithLocalTzType";

        public TimeWithLocalTzType() {
            super(IDENTIFIER, "", Schema.FieldType.DATETIME);
        }
    }

    public static class TimeType
    extends LogicalTypes.PassThroughLogicalType<Instant> {
        public static final String IDENTIFIER = "SqlTimeType";

        public TimeType() {
            super(IDENTIFIER, "", Schema.FieldType.DATETIME);
        }
    }

    public static class DateType
    extends LogicalTypes.PassThroughLogicalType<Instant> {
        public static final String IDENTIFIER = "SqlDateType";

        public DateType() {
            super(IDENTIFIER, "", Schema.FieldType.DATETIME);
        }
    }
}

