/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import javax.annotation.Nullable;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.AggregateCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamBuiltinAggregations;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.values.Row;

public class AggregationCombineFnAdapter<T> {
    public static Combine.CombineFn<?, ?, ?> createCombineFn(AggregateCall call, Schema.Field field, String functionName) {
        if (call.isDistinct()) {
            throw new IllegalArgumentException("Does not support " + call.getAggregation().getName() + " DISTINCT");
        }
        Combine.CombineFn<?, ?, ?> combineFn = call.getAggregation() instanceof SqlUserDefinedAggFunction ? AggregationCombineFnAdapter.getUdafCombineFn(call) : BeamBuiltinAggregations.create(functionName, field.getType());
        if (call.getArgList().isEmpty()) {
            return new SingleInputCombiner((Combine.CombineFn<Object, Object, Object>)combineFn);
        }
        if (call.getArgList().size() == 1) {
            return new SingleInputCombiner((Combine.CombineFn<Object, Object, Object>)combineFn);
        }
        return new MultiInputCombiner((Combine.CombineFn<Row, Object, Object>)combineFn);
    }

    public static Combine.CombineFn<Row, ?, Row> createConstantCombineFn() {
        return ConstantEmpty.INSTANCE;
    }

    private static Combine.CombineFn<?, ?, ?> getUdafCombineFn(AggregateCall call) {
        try {
            return ((UdafImpl)((SqlUserDefinedAggFunction)call.getAggregation()).function).getCombineFn();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static class ConstantEmpty
    extends Combine.CombineFn<Row, Row, Row> {
        private static final Schema EMPTY_SCHEMA = Schema.builder().build();
        private static final Row EMPTY_ROW = Row.withSchema((Schema)EMPTY_SCHEMA).build();
        public static final ConstantEmpty INSTANCE = new ConstantEmpty();

        private ConstantEmpty() {
        }

        public Row createAccumulator() {
            return EMPTY_ROW;
        }

        public Row addInput(Row accumulator, Row input) {
            return EMPTY_ROW;
        }

        public Row mergeAccumulators(Iterable<Row> accumulators) {
            return EMPTY_ROW;
        }

        public Row extractOutput(Row accumulator) {
            return EMPTY_ROW;
        }

        public Coder<Row> getAccumulatorCoder(CoderRegistry registry, Coder<Row> inputCoder) throws CannotProvideCoderException {
            return SchemaCoder.of((Schema)EMPTY_SCHEMA);
        }

        public Coder<Row> getDefaultOutputCoder(CoderRegistry registry, Coder<Row> inputCoder) {
            return SchemaCoder.of((Schema)EMPTY_SCHEMA);
        }
    }

    private static class SingleInputCombiner
    extends WrappedCombinerBase<Object> {
        SingleInputCombiner(Combine.CombineFn<Object, Object, Object> combineFn) {
            super(combineFn);
        }

        @Override
        Object getInput(Object input) {
            return input;
        }
    }

    private static class MultiInputCombiner
    extends WrappedCombinerBase<Row> {
        MultiInputCombiner(Combine.CombineFn<Row, Object, Object> combineFn) {
            super(combineFn);
        }

        @Override
        Row getInput(Row input) {
            for (Object o : input.getValues()) {
                if (o != null) continue;
                return null;
            }
            return input;
        }
    }

    private static abstract class WrappedCombinerBase<T>
    extends Combine.CombineFn<T, Object, Object> {
        Combine.CombineFn<T, Object, Object> combineFn;

        WrappedCombinerBase(Combine.CombineFn<T, Object, Object> combineFn) {
            this.combineFn = combineFn;
        }

        public Object createAccumulator() {
            return this.combineFn.createAccumulator();
        }

        public Object addInput(Object accumulator, T input) {
            T processedInput = this.getInput(input);
            return processedInput == null ? accumulator : this.combineFn.addInput(accumulator, this.getInput(input));
        }

        public Object mergeAccumulators(Iterable<Object> accumulators) {
            return this.combineFn.mergeAccumulators(accumulators);
        }

        public Object extractOutput(Object accumulator) {
            return this.combineFn.extractOutput(accumulator);
        }

        @Nullable
        abstract T getInput(T var1);

        public Coder<Object> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) throws CannotProvideCoderException {
            return this.combineFn.getAccumulatorCoder(registry, inputCoder);
        }
    }
}

