/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Values;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;

public class BeamValuesRel
extends Values
implements BeamRelNode {
    public BeamValuesRel(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traits) {
        super(cluster, rowType, tuples, traits);
    }

    @Override
    public Map<String, String> getPipelineOptions() {
        return ImmutableMap.of();
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private Row tupleToRow(Schema schema, ImmutableList<RexLiteral> tuple) {
        return (Row)IntStream.range(0, tuple.size()).mapToObj(i -> BeamTableUtils.autoCastField(schema.getField(i), ((RexLiteral)tuple.get(i)).getValue())).collect(Row.toRow((Schema)schema));
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 0 ? 1 : 0) != 0, (String)"Should not have received input for %s: %s", (Object)BeamValuesRel.class.getSimpleName(), pinput);
            Schema schema = CalciteUtils.toSchema(BeamValuesRel.this.getRowType());
            List rows = BeamValuesRel.this.tuples.stream().map(tuple -> BeamValuesRel.this.tupleToRow(schema, tuple)).collect(Collectors.toList());
            return (PCollection)pinput.getPipeline().begin().apply((PTransform)Create.of(rows).withRowSchema(schema));
        }
    }
}

