/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.plan;

import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCostFactory;

public class RelOptCostImpl
implements RelOptCost {
    public static final RelOptCostFactory FACTORY = new Factory();
    private final double value;

    public RelOptCostImpl(double value) {
        this.value = value;
    }

    @Override
    public double getRows() {
        return this.value;
    }

    @Override
    public double getIo() {
        return 0.0;
    }

    @Override
    public double getCpu() {
        return 0.0;
    }

    @Override
    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    @Override
    public boolean isLe(RelOptCost other) {
        return this.getRows() <= other.getRows();
    }

    @Override
    public boolean isLt(RelOptCost other) {
        return this.getRows() < other.getRows();
    }

    public int hashCode() {
        return Double.hashCode(this.getRows());
    }

    @Override
    public boolean equals(RelOptCost other) {
        return this.getRows() == other.getRows();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelOptCostImpl) {
            return this.equals((RelOptCost)obj);
        }
        return false;
    }

    @Override
    public boolean isEqWithEpsilon(RelOptCost other) {
        return Math.abs(this.getRows() - other.getRows()) < 1.0E-5;
    }

    @Override
    public RelOptCost minus(RelOptCost other) {
        return new RelOptCostImpl(this.getRows() - other.getRows());
    }

    @Override
    public RelOptCost plus(RelOptCost other) {
        return new RelOptCostImpl(this.getRows() + other.getRows());
    }

    @Override
    public RelOptCost multiplyBy(double factor) {
        return new RelOptCostImpl(this.getRows() * factor);
    }

    @Override
    public double divideBy(RelOptCost cost) {
        RelOptCostImpl that = (RelOptCostImpl)cost;
        return this.getRows() / that.getRows();
    }

    @Override
    public String toString() {
        if (this.value == Double.MAX_VALUE) {
            return "huge";
        }
        return Double.toString(this.value);
    }

    private static class Factory
    implements RelOptCostFactory {
        private Factory() {
        }

        @Override
        public RelOptCost makeCost(double dRows, double dCpu, double dIo) {
            return new RelOptCostImpl(dRows);
        }

        @Override
        public RelOptCost makeHugeCost() {
            return new RelOptCostImpl(Double.MAX_VALUE);
        }

        @Override
        public RelOptCost makeInfiniteCost() {
            return new RelOptCostImpl(Double.POSITIVE_INFINITY);
        }

        @Override
        public RelOptCost makeTinyCost() {
            return new RelOptCostImpl(1.0);
        }

        @Override
        public RelOptCost makeZeroCost() {
            return new RelOptCostImpl(0.0);
        }
    }
}

