/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.Context;

public class Contexts {
    public static final EmptyContext EMPTY_CONTEXT = new EmptyContext();

    private Contexts() {
    }

    @Deprecated
    public static Context withConfig(CalciteConnectionConfig config) {
        return Contexts.of((Object)config);
    }

    public static Context empty() {
        return EMPTY_CONTEXT;
    }

    public static Context of(Object o) {
        return new WrapContext(o);
    }

    public static Context of(Object ... os) {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (Object o : os) {
            if (o == null) continue;
            contexts.add(Contexts.of(o));
        }
        return Contexts.chain(contexts);
    }

    public static Context chain(Context ... contexts) {
        return Contexts.chain(ImmutableList.copyOf(contexts));
    }

    private static Context chain(Iterable<? extends Context> contexts) {
        ArrayList<Context> list = new ArrayList<Context>();
        for (Context context : contexts) {
            Contexts.build(list, context);
        }
        switch (list.size()) {
            case 0: {
                return Contexts.empty();
            }
            case 1: {
                return (Context)list.get(0);
            }
        }
        return new ChainContext(ImmutableList.copyOf(list));
    }

    private static void build(List<Context> list, Context context) {
        if (context == EMPTY_CONTEXT || list.contains(context)) {
            return;
        }
        if (context instanceof ChainContext) {
            ChainContext chainContext = (ChainContext)context;
            for (Context child : chainContext.contexts) {
                Contexts.build(list, child);
            }
        } else {
            list.add(context);
        }
    }

    private static final class ChainContext
    implements Context {
        final ImmutableList<Context> contexts;

        ChainContext(ImmutableList<Context> contexts) {
            this.contexts = Objects.requireNonNull(contexts);
            for (Context context : contexts) {
                assert (!(context instanceof ChainContext)) : "must be flat";
            }
        }

        public <T> T unwrap(Class<T> clazz) {
            for (Context context : this.contexts) {
                T t = context.unwrap(clazz);
                if (t == null) continue;
                return t;
            }
            return null;
        }
    }

    static class EmptyContext
    implements Context {
        EmptyContext() {
        }

        public <T> T unwrap(Class<T> clazz) {
            return null;
        }
    }

    private static class WrapContext
    implements Context {
        final Object target;

        WrapContext(Object target) {
            this.target = Objects.requireNonNull(target);
        }

        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this.target)) {
                return clazz.cast(this.target);
            }
            return null;
        }
    }
}

