/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.org.apache.calcite.DataContext;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.Enumerator;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Blocks;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Types;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelCollation;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Calc;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexProgram;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexSimplify;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlConformance;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.BuiltInMethod;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Pair;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Util;

public class EnumerableCalc
extends Calc
implements EnumerableRel {
    public EnumerableCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program) {
        super(cluster, traitSet, input, program);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (!program.containsAggs());
    }

    @Deprecated
    public EnumerableCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program, List<RelCollation> collationList) {
        this(cluster, traitSet, input, program);
        Util.discard(collationList);
    }

    public static EnumerableCalc create(RelNode input, RexProgram program) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSet().replace(EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.calc(mq, input, program)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.calc(mq, input, program));
        return new EnumerableCalc(cluster, traitSet, input, program);
    }

    @Override
    public EnumerableCalc copy(RelTraitSet traitSet, RelNode child, RexProgram program) {
        return new EnumerableCalc(this.getCluster(), traitSet, child, program);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockStatement moveNextBody;
        RelMetadataQuery mq;
        RelOptPredicateList predicates;
        RexSimplify simplify;
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.prefer(result.format));
        Type outputJavaType = physType.getJavaRowType();
        Type enumeratorType = Types.of(Enumerator.class, new Type[]{outputJavaType});
        Type inputJavaType = result.physType.getJavaRowType();
        ParameterExpression inputEnumerator = Expressions.parameter(Types.of(Enumerator.class, new Type[]{inputJavaType}), "inputEnumerator");
        Expression input = RexToLixTranslator.convert(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_CURRENT.method, new Expression[0]), inputJavaType);
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        RexProgram program = this.program.normalize(rexBuilder, simplify = new RexSimplify(rexBuilder, predicates = (mq = RelMetadataQuery.instance()).getPulledUpPredicates(child), RexUtil.EXECUTOR));
        if (program.getCondition() == null) {
            moveNextBody = Blocks.toFunctionBlock(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, new Expression[0]));
        } else {
            BlockBuilder builder2 = new BlockBuilder();
            Expression condition = RexToLixTranslator.translateCondition(program, typeFactory, builder2, new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(input, result.physType))), implementor.allCorrelateVariables, implementor.getConformance());
            builder2.add(Expressions.ifThen(condition, Expressions.return_(null, Expressions.constant(true))));
            moveNextBody = Expressions.block(Expressions.while_(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, new Expression[0]), builder2.toBlock()), Expressions.return_(null, Expressions.constant(false)));
        }
        BlockBuilder builder3 = new BlockBuilder();
        SqlConformance conformance = (SqlConformance)implementor.map.getOrDefault("_conformance", SqlConformanceEnum.DEFAULT);
        List<Expression> expressions = RexToLixTranslator.translateProjects(program, typeFactory, conformance, builder3, physType, DataContext.ROOT, new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(input, result.physType))), implementor.allCorrelateVariables);
        builder3.add(Expressions.return_(null, physType.record(expressions)));
        BlockStatement currentBody = builder3.toBlock();
        Expression inputEnumerable = builder.append("inputEnumerable", result.block, false);
        NewExpression body = Expressions.new_(enumeratorType, EnumUtils.NO_EXPRS, Expressions.list(Expressions.fieldDecl(17, inputEnumerator, Expressions.call(inputEnumerable, BuiltInMethod.ENUMERABLE_ENUMERATOR.method, new Expression[0])), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_RESET.method, EnumUtils.NO_PARAMS, Blocks.toFunctionBlock(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_RESET.method, new Expression[0]))), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, EnumUtils.NO_PARAMS, moveNextBody), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_CLOSE.method, EnumUtils.NO_PARAMS, Blocks.toFunctionBlock(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_CLOSE.method, new Expression[0]))), Expressions.methodDecl(1, Object.class, "current", EnumUtils.NO_PARAMS, currentBody)));
        builder.add(Expressions.return_(null, Expressions.new_(BuiltInMethod.ABSTRACT_ENUMERABLE_CTOR.constructor, EnumUtils.NO_EXPRS, ImmutableList.of(Expressions.methodDecl(1, enumeratorType, BuiltInMethod.ENUMERABLE_ENUMERATOR.method.getName(), EnumUtils.NO_PARAMS, Blocks.toFunctionBlock(body))))));
        return implementor.result(physType, builder.toBlock());
    }

    @Override
    public RexProgram getProgram() {
        return this.program;
    }
}

