/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexFieldAccess;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Pair;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.joinlibrary.Join;
import org.apache.beam.sdk.extensions.sql.BeamSqlSeekableTable;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamJoinTransforms;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.joda.time.Duration;

public class BeamJoinRel
extends org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Join
implements BeamRelNode {
    public BeamJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traits, left, right, condition, variablesSet, joinType);
    }

    @Override
    public org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BeamJoinRel(this.getCluster(), traitSet, left, right, conditionExpr, this.variablesSet, joinType);
    }

    @Override
    public List<RelNode> getPCollectionInputs() {
        if (this.isSideInputLookupJoin()) {
            return ImmutableList.of((Object)BeamSqlRelUtils.getBeamRelInput(this.getInputs().get((Integer)this.nonSeekableInputIndex().get())));
        }
        return BeamRelNode.super.getPCollectionInputs();
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        if (this.isSideInputLookupJoin()) {
            return new SideInputLookupJoin();
        }
        if (this.isSideInputJoin()) {
            if (this.joinType == JoinRelType.FULL) {
                throw new UnsupportedOperationException("FULL OUTER JOIN is not supported when join a bounded table with an unbounded table.");
            }
            BeamRelNode leftRelNode = BeamSqlRelUtils.getBeamRelInput(this.left);
            BeamRelNode rightRelNode = BeamSqlRelUtils.getBeamRelInput(this.right);
            if (this.joinType == JoinRelType.LEFT && leftRelNode.isBounded() == PCollection.IsBounded.BOUNDED || this.joinType == JoinRelType.RIGHT && rightRelNode.isBounded() == PCollection.IsBounded.BOUNDED) {
                throw new UnsupportedOperationException("LEFT side of an OUTER JOIN must be Unbounded table.");
            }
            return new SideInputJoin();
        }
        return new StandardJoin();
    }

    private boolean isSideInputJoin() {
        BeamRelNode leftRelNode = BeamSqlRelUtils.getBeamRelInput(this.left);
        BeamRelNode rightRelNode = BeamSqlRelUtils.getBeamRelInput(this.right);
        return leftRelNode.isBounded() == PCollection.IsBounded.BOUNDED && rightRelNode.isBounded() == PCollection.IsBounded.UNBOUNDED || leftRelNode.isBounded() == PCollection.IsBounded.UNBOUNDED && rightRelNode.isBounded() == PCollection.IsBounded.BOUNDED;
    }

    private boolean isSideInputLookupJoin() {
        return this.seekableInputIndex().isPresent() && this.nonSeekableInputIndex().isPresent();
    }

    private Optional<Integer> seekableInputIndex() {
        BeamRelNode leftRelNode = BeamSqlRelUtils.getBeamRelInput(this.left);
        BeamRelNode rightRelNode = BeamSqlRelUtils.getBeamRelInput(this.right);
        return this.seekable(leftRelNode) ? Optional.of((Object)0) : (this.seekable(rightRelNode) ? Optional.of((Object)1) : Optional.absent());
    }

    private Optional<Integer> nonSeekableInputIndex() {
        BeamRelNode leftRelNode = BeamSqlRelUtils.getBeamRelInput(this.left);
        BeamRelNode rightRelNode = BeamSqlRelUtils.getBeamRelInput(this.right);
        return !this.seekable(leftRelNode) ? Optional.of((Object)0) : (!this.seekable(rightRelNode) ? Optional.of((Object)1) : Optional.absent());
    }

    private <T> void verifySupportedTrigger(PCollection<T> pCollection) {
        WindowingStrategy windowingStrategy = pCollection.getWindowingStrategy();
        if (PCollection.IsBounded.UNBOUNDED.equals((Object)pCollection.isBounded()) && !this.triggersOncePerWindow(windowingStrategy)) {
            throw new UnsupportedOperationException("Joining unbounded PCollections is currently only supported for non-global windows with triggers that are known to produce output once per window,such as the default trigger with zero allowed lateness. In these cases Beam can guarantee it joins all input elements once per window. " + windowingStrategy + " is not supported");
        }
    }

    private boolean triggersOncePerWindow(WindowingStrategy windowingStrategy) {
        Trigger trigger = windowingStrategy.getTrigger();
        return !(windowingStrategy.getWindowFn() instanceof GlobalWindows) && trigger instanceof DefaultTrigger && Duration.ZERO.equals((Object)windowingStrategy.getAllowedLateness());
    }

    private PCollection<Row> standardJoin(PCollection<KV<Row, Row>> extractedLeftRows, PCollection<KV<Row, Row>> extractedRightRows, Schema leftSchema, Schema rightSchema) {
        PCollection joinedRows = null;
        switch (this.joinType) {
            case LEFT: {
                Schema rigthNullSchema = this.buildNullSchema(rightSchema);
                Row rightNullRow = Row.nullRow((Schema)rigthNullSchema);
                extractedRightRows = BeamJoinRel.setValueCoder(extractedRightRows, SchemaCoder.of((Schema)rigthNullSchema));
                joinedRows = Join.leftOuterJoin(extractedLeftRows, extractedRightRows, (Object)rightNullRow);
                break;
            }
            case RIGHT: {
                Schema leftNullSchema = this.buildNullSchema(leftSchema);
                Row leftNullRow = Row.nullRow((Schema)leftNullSchema);
                extractedLeftRows = BeamJoinRel.setValueCoder(extractedLeftRows, SchemaCoder.of((Schema)leftNullSchema));
                joinedRows = Join.rightOuterJoin(extractedLeftRows, extractedRightRows, (Object)leftNullRow);
                break;
            }
            case FULL: {
                Schema leftNullSchema = this.buildNullSchema(leftSchema);
                Schema rightNullSchema = this.buildNullSchema(rightSchema);
                Row leftNullRow = Row.nullRow((Schema)leftNullSchema);
                Row rightNullRow = Row.nullRow((Schema)rightNullSchema);
                extractedLeftRows = BeamJoinRel.setValueCoder(extractedLeftRows, SchemaCoder.of((Schema)leftNullSchema));
                extractedRightRows = BeamJoinRel.setValueCoder(extractedRightRows, SchemaCoder.of((Schema)rightNullSchema));
                joinedRows = Join.fullOuterJoin(extractedLeftRows, extractedRightRows, (Object)leftNullRow, (Object)rightNullRow);
                break;
            }
            default: {
                joinedRows = Join.innerJoin(extractedLeftRows, extractedRightRows);
            }
        }
        Schema schema = CalciteUtils.toSchema(this.getRowType());
        return ((PCollection)joinedRows.apply("JoinParts2WholeRow", (PTransform)MapElements.via((SimpleFunction)new BeamJoinTransforms.JoinParts2WholeRow(schema)))).setRowSchema(schema);
    }

    public PCollection<Row> sideInputJoin(PCollection<KV<Row, Row>> extractedLeftRows, PCollection<KV<Row, Row>> extractedRightRows, Schema leftSchema, Schema rightSchema) {
        Row realRightNullRow;
        PCollection<KV<Row, Row>> realRightRows;
        boolean swapped = extractedLeftRows.isBounded() == PCollection.IsBounded.BOUNDED;
        JoinRelType realJoinType = swapped && this.joinType != JoinRelType.INNER ? JoinRelType.LEFT : this.joinType;
        PCollection<KV<Row, Row>> realLeftRows = swapped ? extractedRightRows : extractedLeftRows;
        PCollection<KV<Row, Row>> pCollection = realRightRows = swapped ? extractedLeftRows : extractedRightRows;
        if (swapped) {
            Schema leftNullSchema = this.buildNullSchema(leftSchema);
            realRightRows = BeamJoinRel.setValueCoder(realRightRows, SchemaCoder.of((Schema)leftNullSchema));
            realRightNullRow = Row.nullRow((Schema)leftNullSchema);
        } else {
            Schema rightNullSchema = this.buildNullSchema(rightSchema);
            realRightRows = BeamJoinRel.setValueCoder(realRightRows, SchemaCoder.of((Schema)rightNullSchema));
            realRightNullRow = Row.nullRow((Schema)rightNullSchema);
        }
        return this.sideInputJoinHelper(realJoinType, realLeftRows, realRightRows, realRightNullRow, swapped);
    }

    private PCollection<Row> sideInputJoinHelper(JoinRelType joinType, PCollection<KV<Row, Row>> leftRows, PCollection<KV<Row, Row>> rightRows, Row rightNullRow, boolean swapped) {
        PCollectionView rowsView = (PCollectionView)rightRows.apply((PTransform)View.asMultimap());
        Schema schema = CalciteUtils.toSchema(this.getRowType());
        return ((PCollection)leftRows.apply((PTransform)ParDo.of((DoFn)new BeamJoinTransforms.SideInputJoinDoFn(joinType, rightNullRow, (PCollectionView<Map<Row, Iterable<Row>>>)rowsView, swapped, schema)).withSideInputs(new PCollectionView[]{rowsView}))).setRowSchema(schema);
    }

    private Schema buildNullSchema(Schema schema) {
        Schema.Builder builder = Schema.builder();
        builder.addFields(schema.getFields().stream().map(f -> f.withNullable(true)).collect(Collectors.toList()));
        return builder.build();
    }

    private static <K, V> PCollection<KV<K, V>> setValueCoder(PCollection<KV<K, V>> kvs, Coder<V> valueCoder) {
        KvCoder coder = (KvCoder)kvs.getCoder();
        return kvs.setCoder((Coder)KvCoder.of((Coder)coder.getKeyCoder(), valueCoder));
    }

    private static Schema.Field getFieldBasedOnRexNode(Schema schema, RexNode rexNode, int leftRowColumnCount) {
        if (rexNode instanceof RexInputRef) {
            return schema.getField(((RexInputRef)rexNode).getIndex() - leftRowColumnCount);
        }
        if (rexNode instanceof RexFieldAccess) {
            return BeamJoinRel.getFieldBasedOnRexFieldAccess(schema, (RexFieldAccess)rexNode, leftRowColumnCount);
        }
        throw new UnsupportedOperationException("Does not support " + rexNode.getType() + " in JOIN.");
    }

    private static Schema.Field getFieldBasedOnRexFieldAccess(Schema schema, RexFieldAccess rexFieldAccess, int leftRowColumnCount) {
        ArrayDeque<RexFieldAccess> fieldAccessStack = new ArrayDeque<RexFieldAccess>();
        fieldAccessStack.push(rexFieldAccess);
        RexFieldAccess curr = rexFieldAccess;
        while (curr.getReferenceExpr() instanceof RexFieldAccess) {
            curr = (RexFieldAccess)curr.getReferenceExpr();
            fieldAccessStack.push(curr);
        }
        if (!(curr.getReferenceExpr() instanceof RexInputRef)) {
            throw new UnsupportedOperationException("Does not support " + curr.getReferenceExpr().getType() + " in JOIN.");
        }
        RexInputRef inputRef = (RexInputRef)curr.getReferenceExpr();
        Schema.Field curField = schema.getField(inputRef.getIndex() - leftRowColumnCount);
        while (fieldAccessStack.size() > 0) {
            curr = (RexFieldAccess)fieldAccessStack.pop();
            curField = curField.getType().getRowSchema().getField(curr.getField().getIndex());
        }
        return curField;
    }

    private List<Pair<RexNode, RexNode>> extractJoinRexNodes() {
        if (this.condition instanceof RexLiteral && ((Boolean)((RexLiteral)this.condition).getValue()).booleanValue()) {
            throw new UnsupportedOperationException("CROSS JOIN is not supported!");
        }
        RexCall call = (RexCall)this.condition;
        ArrayList<Pair<RexNode, RexNode>> pairs = new ArrayList<Pair<RexNode, RexNode>>();
        if ("AND".equals(call.getOperator().getName())) {
            List<RexNode> operands = call.getOperands();
            for (RexNode rexNode : operands) {
                Pair<RexNode, RexNode> pair = this.extractJoinPairOfRexNodes((RexCall)rexNode);
                pairs.add(pair);
            }
        } else if ("=".equals(call.getOperator().getName())) {
            pairs.add(this.extractJoinPairOfRexNodes(call));
        } else {
            throw new UnsupportedOperationException("Operator " + call.getOperator().getName() + " is not supported in join condition");
        }
        return pairs;
    }

    private Pair<RexNode, RexNode> extractJoinPairOfRexNodes(RexCall rexCall) {
        int rightIndex;
        if (!rexCall.getOperator().getName().equals("=")) {
            throw new UnsupportedOperationException("Non equi-join is not supported");
        }
        if (this.isIllegalJoinConjunctionClause(rexCall)) {
            throw new UnsupportedOperationException("Only support column reference or struct field access in conjunction clause");
        }
        int leftIndex = this.getColumnIndex(rexCall.getOperands().get(0));
        if (leftIndex < (rightIndex = this.getColumnIndex(rexCall.getOperands().get(1)))) {
            return new Pair<RexNode, RexNode>(rexCall.getOperands().get(0), rexCall.getOperands().get(1));
        }
        return new Pair<RexNode, RexNode>(rexCall.getOperands().get(1), rexCall.getOperands().get(0));
    }

    private boolean isIllegalJoinConjunctionClause(RexCall rexCall) {
        return !(rexCall.getOperands().get(0) instanceof RexInputRef) && !(rexCall.getOperands().get(0) instanceof RexFieldAccess) || !(rexCall.getOperands().get(1) instanceof RexInputRef) && !(rexCall.getOperands().get(1) instanceof RexFieldAccess);
    }

    private int getColumnIndex(RexNode rexNode) {
        if (rexNode instanceof RexInputRef) {
            return ((RexInputRef)rexNode).getIndex();
        }
        if (rexNode instanceof RexFieldAccess) {
            return this.getColumnIndex(((RexFieldAccess)rexNode).getReferenceExpr());
        }
        throw new UnsupportedOperationException("Cannot get column index from " + rexNode.getType());
    }

    private boolean seekable(BeamRelNode relNode) {
        BeamIOSourceRel srcRel;
        BeamSqlTable sourceTable;
        return relNode instanceof BeamIOSourceRel && (sourceTable = (srcRel = (BeamIOSourceRel)relNode).getBeamSqlTable()) instanceof BeamSqlSeekableTable;
    }

    private class StandardJoin
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private StandardJoin() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Schema leftSchema = CalciteUtils.toSchema(BeamJoinRel.this.left.getRowType());
            Schema rightSchema = CalciteUtils.toSchema(BeamJoinRel.this.right.getRowType());
            PCollectionList keyedInputs = (PCollectionList)pinput.apply((PTransform)new ExtractJoinKeys());
            PCollection extractedLeftRows = keyedInputs.get(0);
            PCollection extractedRightRows = keyedInputs.get(1);
            WindowFn leftWinFn = extractedLeftRows.getWindowingStrategy().getWindowFn();
            WindowFn rightWinFn = extractedRightRows.getWindowingStrategy().getWindowFn();
            try {
                leftWinFn.verifyCompatibility(rightWinFn);
            }
            catch (IncompatibleWindowException e) {
                throw new IllegalArgumentException("WindowFns must match for a bounded-vs-bounded/unbounded-vs-unbounded join.", e);
            }
            BeamJoinRel.this.verifySupportedTrigger(extractedLeftRows);
            BeamJoinRel.this.verifySupportedTrigger(extractedRightRows);
            return BeamJoinRel.this.standardJoin((PCollection<KV<Row, Row>>)extractedLeftRows, (PCollection<KV<Row, Row>>)extractedRightRows, leftSchema, rightSchema);
        }
    }

    private class SideInputJoin
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private SideInputJoin() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Schema leftSchema = CalciteUtils.toSchema(BeamJoinRel.this.left.getRowType());
            Schema rightSchema = CalciteUtils.toSchema(BeamJoinRel.this.right.getRowType());
            PCollectionList keyedInputs = (PCollectionList)pinput.apply((PTransform)new ExtractJoinKeys());
            PCollection extractedLeftRows = keyedInputs.get(0);
            PCollection extractedRightRows = keyedInputs.get(1);
            return BeamJoinRel.this.sideInputJoin((PCollection<KV<Row, Row>>)extractedLeftRows, (PCollection<KV<Row, Row>>)extractedRightRows, leftSchema, rightSchema);
        }
    }

    private class ExtractJoinKeys
    extends PTransform<PCollectionList<Row>, PCollectionList<KV<Row, Row>>> {
        private ExtractJoinKeys() {
        }

        public PCollectionList<KV<Row, Row>> expand(PCollectionList<Row> pinput) {
            BeamRelNode leftRelNode = BeamSqlRelUtils.getBeamRelInput(BeamJoinRel.this.left);
            Schema leftSchema = CalciteUtils.toSchema(BeamJoinRel.this.left.getRowType());
            Schema rightSchema = CalciteUtils.toSchema(BeamJoinRel.this.right.getRowType());
            assert (pinput.size() == 2);
            PCollection leftRows = pinput.get(0);
            PCollection rightRows = pinput.get(1);
            int leftRowColumnCount = leftRelNode.getRowType().getFieldCount();
            List pairs = BeamJoinRel.this.extractJoinRexNodes();
            Schema extractKeySchemaLeft = (Schema)pairs.stream().map(pair -> BeamJoinRel.getFieldBasedOnRexNode(leftSchema, (RexNode)pair.getKey(), 0)).collect(Schema.toSchema());
            Schema extractKeySchemaRight = (Schema)pairs.stream().map(pair -> BeamJoinRel.getFieldBasedOnRexNode(rightSchema, (RexNode)pair.getValue(), leftRowColumnCount)).collect(Schema.toSchema());
            SchemaCoder extractKeyRowCoder = SchemaCoder.of((Schema)extractKeySchemaLeft);
            PCollection extractedLeftRows = ((PCollection)((PCollection)leftRows.apply("left_TimestampCombiner", (PTransform)Window.configure().withTimestampCombiner(TimestampCombiner.EARLIEST))).apply("left_ExtractJoinFields", (PTransform)MapElements.via((SimpleFunction)new BeamJoinTransforms.ExtractJoinFields(true, pairs, extractKeySchemaLeft, 0)))).setCoder((Coder)KvCoder.of((Coder)extractKeyRowCoder, (Coder)leftRows.getCoder()));
            PCollection extractedRightRows = ((PCollection)((PCollection)rightRows.apply("right_TimestampCombiner", (PTransform)Window.configure().withTimestampCombiner(TimestampCombiner.EARLIEST))).apply("right_ExtractJoinFields", (PTransform)MapElements.via((SimpleFunction)new BeamJoinTransforms.ExtractJoinFields(false, pairs, extractKeySchemaRight, leftRowColumnCount)))).setCoder((Coder)KvCoder.of((Coder)extractKeyRowCoder, (Coder)rightRows.getCoder()));
            return PCollectionList.of((PCollection)extractedLeftRows).and(extractedRightRows);
        }
    }

    private class SideInputLookupJoin
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private SideInputLookupJoin() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Schema schema = CalciteUtils.toSchema(BeamJoinRel.this.getRowType());
            BeamRelNode seekableRel = BeamSqlRelUtils.getBeamRelInput(BeamJoinRel.this.getInput((Integer)BeamJoinRel.this.seekableInputIndex().get()));
            BeamRelNode nonSeekableRel = BeamSqlRelUtils.getBeamRelInput(BeamJoinRel.this.getInput((Integer)BeamJoinRel.this.nonSeekableInputIndex().get()));
            int factColOffset = (Integer)BeamJoinRel.this.nonSeekableInputIndex().get() == 0 ? 0 : CalciteUtils.toSchema(seekableRel.getRowType()).getFieldCount();
            int lkpColOffset = (Integer)BeamJoinRel.this.seekableInputIndex().get() == 0 ? 0 : CalciteUtils.toSchema(nonSeekableRel.getRowType()).getFieldCount();
            BeamIOSourceRel seekableInput = (BeamIOSourceRel)seekableRel;
            BeamSqlSeekableTable seekableTable = (BeamSqlSeekableTable)((Object)seekableInput.getBeamSqlTable());
            PCollection nonSeekableInput = pinput.get(0);
            return ((PCollection)nonSeekableInput.apply("join_as_lookup", (PTransform)new BeamJoinTransforms.JoinAsLookup(BeamJoinRel.this.condition, seekableTable, CalciteUtils.toSchema(seekableInput.getRowType()), schema, factColOffset, lkpColOffset))).setRowSchema(schema);
        }
    }
}

