/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.cache.Cache;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.cache.CacheBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.DataContext;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.Helper;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.CalciteSystemProperty;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.interpreter.Compiler;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.interpreter.InterpretableConvention;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.interpreter.InterpretableRel;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.interpreter.Node;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.interpreter.Row;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.interpreter.Sink;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.Enumerator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.FieldDeclaration;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.VisitorImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.ArrayBindable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.Bindable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.Hook;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.Typed;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.Utilities;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Util;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.CompileException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.ICompilerFactory;

public class EnumerableInterpretable
extends ConverterImpl
implements InterpretableRel {
    private static final Cache<String, Bindable> BINDABLE_CACHE = CacheBuilder.newBuilder().concurrencyLevel(CalciteSystemProperty.BINDABLE_CACHE_CONCURRENCY_LEVEL.value()).maximumSize(CalciteSystemProperty.BINDABLE_CACHE_MAX_SIZE.value().intValue()).build();

    protected EnumerableInterpretable(RelOptCluster cluster, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, cluster.traitSetOf((RelTrait)InterpretableConvention.INSTANCE), input);
    }

    @Override
    public EnumerableInterpretable copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableInterpretable(this.getCluster(), EnumerableInterpretable.sole(inputs));
    }

    @Override
    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        Bindable bindable = EnumerableInterpretable.toBindable(implementor.internalParameters, implementor.spark, (EnumerableRel)this.getInput(), EnumerableRel.Prefer.ARRAY);
        ArrayBindable arrayBindable = EnumerableInterpretable.box(bindable);
        Enumerable<Object[]> enumerable = arrayBindable.bind(implementor.dataContext);
        return new EnumerableNode(enumerable, implementor.compiler, this);
    }

    public static Bindable toBindable(Map<String, Object> parameters, CalcitePrepare.SparkHandler spark, EnumerableRel rel, EnumerableRel.Prefer prefer) {
        EnumerableRelImplementor relImplementor = new EnumerableRelImplementor(rel.getCluster().getRexBuilder(), parameters);
        ClassDeclaration expr = relImplementor.implementRoot(rel, prefer);
        String s = Expressions.toString(expr.memberDeclarations, "\n", false);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, s);
        }
        Hook.JAVA_PLAN.run(s);
        try {
            if (spark != null && spark.enabled()) {
                return spark.compile(expr, s);
            }
            return EnumerableInterpretable.getBindable(expr, s, rel.getRowType().getFieldCount());
        }
        catch (Exception e) {
            throw Helper.INSTANCE.wrap("Error while compiling generated Java code:\n" + s, e);
        }
    }

    static Bindable getBindable(ClassDeclaration expr, String s, int fieldCount) throws CompileException, IOException, ExecutionException {
        Class[] classArray;
        ICompilerFactory compilerFactory;
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setExtendedClass(Utilities.class);
        if (fieldCount == 1) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Bindable.class;
            classArray = classArray2;
            classArray2[1] = Typed.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = ArrayBindable.class;
        }
        cbe.setImplementedInterfaces(classArray);
        cbe.setParentClassLoader(EnumerableInterpretable.class.getClassLoader());
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            cbe.setDebuggingInformation(true, true, true);
        }
        if (CalciteSystemProperty.BINDABLE_CACHE_MAX_SIZE.value() != 0) {
            StaticFieldDetector detector = new StaticFieldDetector();
            expr.accept(detector);
            if (!detector.containsStaticField) {
                return BINDABLE_CACHE.get(s, () -> (Bindable)cbe.createInstance(new StringReader(s)));
            }
        }
        return (Bindable)cbe.createInstance(new StringReader(s));
    }

    static ArrayBindable box(final Bindable bindable) {
        if (bindable instanceof ArrayBindable) {
            return (ArrayBindable)bindable;
        }
        return new ArrayBindable(){

            @Override
            public Class<Object[]> getElementType() {
                return Object[].class;
            }

            @Override
            public Enumerable<Object[]> bind(DataContext dataContext) {
                final Enumerable enumerable = bindable.bind(dataContext);
                return new AbstractEnumerable<Object[]>(){

                    @Override
                    public Enumerator<Object[]> enumerator() {
                        final Enumerator enumerator = enumerable.enumerator();
                        return new Enumerator<Object[]>(){

                            @Override
                            public Object[] current() {
                                return new Object[]{enumerator.current()};
                            }

                            @Override
                            public boolean moveNext() {
                                return enumerator.moveNext();
                            }

                            @Override
                            public void reset() {
                                enumerator.reset();
                            }

                            @Override
                            public void close() {
                                enumerator.close();
                            }
                        };
                    }
                };
            }
        };
    }

    private static class EnumerableNode
    implements Node {
        private final Enumerable<Object[]> enumerable;
        private final Sink sink;

        EnumerableNode(Enumerable<Object[]> enumerable, Compiler compiler, EnumerableInterpretable rel) {
            this.enumerable = enumerable;
            this.sink = compiler.sink(rel);
        }

        @Override
        public void run() throws InterruptedException {
            Enumerator enumerator = this.enumerable.enumerator();
            while (enumerator.moveNext()) {
                Object[] values = (Object[])enumerator.current();
                this.sink.send(Row.of(values));
            }
        }
    }

    static class StaticFieldDetector
    extends VisitorImpl<Void> {
        boolean containsStaticField = false;

        StaticFieldDetector() {
        }

        @Override
        public Void visit(FieldDeclaration fieldDeclaration) {
            this.containsStaticField = (fieldDeclaration.modifier & 8) != 0;
            return this.containsStaticField ? null : (Void)super.visit(fieldDeclaration);
        }
    }
}

