/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.prepare;

import java.io.Reader;
import java.util.List;
import java.util.Properties;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.Context;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.prepare.CalciteSqlValidator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.prepare.Prepare;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelRoot;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexExecutor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlConformance;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.Frameworks;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.Planner;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.Program;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.ValidationException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Pair;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Util;

public class PlannerImpl
implements Planner,
RelOptTable.ViewExpander {
    private final SqlOperatorTable operatorTable;
    private final ImmutableList<Program> programs;
    private final FrameworkConfig config;
    private final ImmutableList<RelTraitDef> traitDefs;
    private final SqlParser.Config parserConfig;
    private final SqlToRelConverter.Config sqlToRelConverterConfig;
    private final SqlRexConvertletTable convertletTable;
    private State state;
    private boolean open;
    private SchemaPlus defaultSchema;
    private JavaTypeFactory typeFactory;
    private RelOptPlanner planner;
    private RexExecutor executor;
    private CalciteSqlValidator validator;
    private SqlNode validatedSqlNode;
    private RelRoot root;

    public PlannerImpl(FrameworkConfig config) {
        this.config = config;
        this.defaultSchema = config.getDefaultSchema();
        this.operatorTable = config.getOperatorTable();
        this.programs = config.getPrograms();
        this.parserConfig = config.getParserConfig();
        this.sqlToRelConverterConfig = config.getSqlToRelConverterConfig();
        this.state = State.STATE_0_CLOSED;
        this.traitDefs = config.getTraitDefs();
        this.convertletTable = config.getConvertletTable();
        this.executor = config.getExecutor();
        this.reset();
    }

    private void ensure(State state) {
        if (state == this.state) {
            return;
        }
        if (state.ordinal() < this.state.ordinal()) {
            throw new IllegalArgumentException("cannot move to " + (Object)((Object)state) + " from " + (Object)((Object)this.state));
        }
        state.from(this);
    }

    @Override
    public RelTraitSet getEmptyTraitSet() {
        return this.planner.emptyTraitSet();
    }

    @Override
    public void close() {
        this.open = false;
        this.typeFactory = null;
        this.state = State.STATE_0_CLOSED;
    }

    @Override
    public void reset() {
        this.ensure(State.STATE_0_CLOSED);
        this.open = true;
        this.state = State.STATE_1_RESET;
    }

    private void ready() {
        switch (this.state) {
            case STATE_0_CLOSED: {
                this.reset();
            }
        }
        this.ensure(State.STATE_1_RESET);
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            Util.discard(rootSchema);
            this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
            this.planner = cluster.getPlanner();
            this.planner.setExecutor(this.executor);
            return null;
        }, this.config);
        this.state = State.STATE_2_READY;
        if (this.traitDefs != null) {
            this.planner.clearRelTraitDefs();
            for (RelTraitDef def : this.traitDefs) {
                this.planner.addRelTraitDef(def);
            }
        }
    }

    @Override
    public SqlNode parse(Reader reader) throws SqlParseException {
        switch (this.state) {
            case STATE_0_CLOSED: 
            case STATE_1_RESET: {
                this.ready();
            }
        }
        this.ensure(State.STATE_2_READY);
        SqlParser parser = SqlParser.create(reader, this.parserConfig);
        SqlNode sqlNode = parser.parseStmt();
        this.state = State.STATE_3_PARSED;
        return sqlNode;
    }

    @Override
    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        this.ensure(State.STATE_3_PARSED);
        SqlConformance conformance = this.conformance();
        CalciteCatalogReader catalogReader = this.createCatalogReader();
        this.validator = new CalciteSqlValidator(this.operatorTable, catalogReader, this.typeFactory, conformance);
        this.validator.setIdentifierExpansion(true);
        try {
            this.validatedSqlNode = this.validator.validate(sqlNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException(e);
        }
        this.state = State.STATE_4_VALIDATED;
        return this.validatedSqlNode;
    }

    private SqlConformance conformance() {
        CalciteConnectionConfig connectionConfig;
        Context context = this.config.getContext();
        if (context != null && (connectionConfig = context.unwrap(CalciteConnectionConfig.class)) != null) {
            return connectionConfig.conformance();
        }
        return this.config.getParserConfig().conformance();
    }

    @Override
    public Pair<SqlNode, RelDataType> validateAndGetType(SqlNode sqlNode) throws ValidationException {
        SqlNode validatedNode = this.validate(sqlNode);
        RelDataType type = this.validator.getValidatedNodeType(validatedNode);
        return Pair.of(validatedNode, type);
    }

    @Override
    public final RelNode convert(SqlNode sql) throws RelConversionException {
        return this.rel((SqlNode)sql).rel;
    }

    @Override
    public RelRoot rel(SqlNode sql) throws RelConversionException {
        this.ensure(State.STATE_4_VALIDATED);
        assert (this.validatedSqlNode != null);
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create(this.planner, rexBuilder);
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withConfig(this.sqlToRelConverterConfig).withTrimUnusedFields(false).withConvertTableAccess(false).build();
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)this, (SqlValidator)this.validator, (Prepare.CatalogReader)this.createCatalogReader(), cluster, this.convertletTable, config);
        this.root = sqlToRelConverter.convertQuery(this.validatedSqlNode, false, true);
        this.root = this.root.withRel(sqlToRelConverter.flattenTypes(this.root.rel, true));
        RelBuilder relBuilder = config.getRelBuilderFactory().create(cluster, null);
        this.root = this.root.withRel(RelDecorrelator.decorrelateQuery(this.root.rel, relBuilder));
        this.state = State.STATE_5_CONVERTED;
        return this.root;
    }

    @Override
    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
        SqlNode sqlNode;
        if (this.planner == null) {
            this.ready();
        }
        SqlParser parser = SqlParser.create(queryString, this.parserConfig);
        try {
            sqlNode = parser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("parse failed", e);
        }
        SqlConformance conformance = this.conformance();
        Prepare.CatalogReader catalogReader = this.createCatalogReader().withSchemaPath((List)schemaPath);
        CalciteSqlValidator validator = new CalciteSqlValidator(this.operatorTable, (CalciteCatalogReader)catalogReader, this.typeFactory, conformance);
        validator.setIdentifierExpansion(true);
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create(this.planner, rexBuilder);
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withConfig(this.sqlToRelConverterConfig).withTrimUnusedFields(false).withConvertTableAccess(false).build();
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)this, (SqlValidator)validator, catalogReader, cluster, this.convertletTable, config);
        RelRoot root = sqlToRelConverter.convertQuery(sqlNode, true, false);
        RelRoot root2 = root.withRel(sqlToRelConverter.flattenTypes(root.rel, true));
        RelBuilder relBuilder = config.getRelBuilderFactory().create(cluster, null);
        return root2.withRel(RelDecorrelator.decorrelateQuery(root.rel, relBuilder));
    }

    private CalciteCatalogReader createCatalogReader() {
        CalciteConnectionConfig connectionConfig;
        SchemaPlus rootSchema = PlannerImpl.rootSchema(this.defaultSchema);
        Context context = this.config.getContext();
        if (context != null) {
            connectionConfig = context.unwrap(CalciteConnectionConfig.class);
        } else {
            Properties properties = new Properties();
            properties.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(this.parserConfig.caseSensitive()));
            connectionConfig = new CalciteConnectionConfigImpl(properties);
        }
        return new CalciteCatalogReader(CalciteSchema.from(rootSchema), CalciteSchema.from(this.defaultSchema).path(null), this.typeFactory, connectionConfig);
    }

    private static SchemaPlus rootSchema(SchemaPlus schema) {
        while (schema.getParentSchema() != null) {
            schema = schema.getParentSchema();
        }
        return schema;
    }

    private RexBuilder createRexBuilder() {
        return new RexBuilder(this.typeFactory);
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public RelNode transform(int ruleSetIndex, RelTraitSet requiredOutputTraits, RelNode rel) throws RelConversionException {
        this.ensure(State.STATE_5_CONVERTED);
        rel.getCluster().setMetadataProvider(new CachingRelMetadataProvider(rel.getCluster().getMetadataProvider(), rel.getCluster().getPlanner()));
        Program program = (Program)this.programs.get(ruleSetIndex);
        return program.run(this.planner, rel, requiredOutputTraits, ImmutableList.of(), ImmutableList.of());
    }

    private static enum State {
        STATE_0_CLOSED{

            @Override
            void from(PlannerImpl planner) {
                planner.close();
            }
        }
        ,
        STATE_1_RESET{

            @Override
            void from(PlannerImpl planner) {
                planner.ensure(2.STATE_0_CLOSED);
                planner.reset();
            }
        }
        ,
        STATE_2_READY{

            @Override
            void from(PlannerImpl planner) {
                STATE_1_RESET.from(planner);
                planner.ready();
            }
        }
        ,
        STATE_3_PARSED,
        STATE_4_VALIDATED,
        STATE_5_CONVERTED;


        void from(PlannerImpl planner) {
            throw new IllegalArgumentException("cannot move from " + (Object)((Object)planner.state) + " to " + (Object)((Object)this));
        }
    }

    @Deprecated
    public class ViewExpanderImpl
    implements RelOptTable.ViewExpander {
        ViewExpanderImpl() {
        }

        @Override
        public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
            return PlannerImpl.this.expandView(rowType, queryString, schemaPath, viewPath);
        }
    }
}

