/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema;

import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;

public class BeamPCollectionTable<InputT>
extends BaseBeamTable {
    private transient PCollection<InputT> upstream;

    public BeamPCollectionTable(PCollection<InputT> upstream) {
        super(upstream.getSchema());
        if (!upstream.hasSchema()) {
            throw new RuntimeException("SQL can only run over PCollections that have schemas.");
        }
        this.upstream = upstream;
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return this.upstream.isBounded();
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        assert (begin.getPipeline() == this.upstream.getPipeline());
        return (PCollection)this.upstream.apply(Convert.toRows());
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        throw new IllegalArgumentException("cannot use [BeamPCollectionTable] as target");
    }
}

