/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.ConnectionProperty;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.Lex;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.rules.CalcRemoveRule;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.rules.SortRemoveRule;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.Hook;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RuleSet;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchemaFactory;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.parser.impl.BeamSqlParserImpl;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelDataTypeSystem;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.CompilerFactoryFactory;

@AutoService(value=Driver.class)
public class JdbcDriver
extends org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.Driver {
    public static final JdbcDriver INSTANCE = new JdbcDriver();
    public static final String CONNECT_STRING_PREFIX = "jdbc:beam:";
    static final String TOP_LEVEL_BEAM_SCHEMA = "beam";

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    public Connection connect(String url, Properties originalConnectionProperties) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties connectionProps = this.ensureDefaultProperties(originalConnectionProperties);
        CalciteConnection calciteConnection = (CalciteConnection)super.connect(url, connectionProps);
        return JdbcConnection.initialize(calciteConnection);
    }

    private Properties ensureDefaultProperties(Properties originalInfo) {
        Properties info = new Properties();
        info.putAll((Map<?, ?>)originalInfo);
        JdbcDriver.setIfNull(info, BuiltInConnectionProperty.TIME_ZONE, "UTC");
        JdbcDriver.setIfNull(info, CalciteConnectionProperty.LEX, Lex.JAVA.name());
        JdbcDriver.setIfNull(info, CalciteConnectionProperty.PARSER_FACTORY, BeamSqlParserImpl.class.getName() + "#FACTORY");
        JdbcDriver.setIfNull(info, CalciteConnectionProperty.TYPE_SYSTEM, BeamRelDataTypeSystem.class.getName());
        JdbcDriver.setIfNull(info, CalciteConnectionProperty.SCHEMA, TOP_LEVEL_BEAM_SCHEMA);
        JdbcDriver.setIfNull(info, CalciteConnectionProperty.SCHEMA_FACTORY, BeamCalciteSchemaFactory.AllProviders.class.getName());
        info.put("beam.userAgent", "BeamSQL/" + ReleaseInfo.getReleaseInfo().getVersion());
        return info;
    }

    private static void setIfNull(Properties info, ConnectionProperty key, String value) {
        if (info.getProperty(key.camelName()) == null) {
            info.setProperty(key.camelName(), value);
        }
    }

    public static JdbcConnection connect(TableProvider tableProvider) {
        try {
            Properties properties = new Properties();
            JdbcDriver.setIfNull(properties, CalciteConnectionProperty.SCHEMA_FACTORY, BeamCalciteSchemaFactory.Empty.class.getName());
            JdbcConnection connection = (JdbcConnection)INSTANCE.connect(CONNECT_STRING_PREFIX, properties);
            connection.setSchema(TOP_LEVEL_BEAM_SCHEMA, tableProvider);
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JdbcDriver.class.getClassLoader());
            CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
        Hook.PLANNER.add(planner -> {
            for (RuleSet ruleSet : BeamRuleSets.getRuleSets()) {
                for (RelOptRule rule : ruleSet) {
                    planner.addRule(rule);
                }
            }
            planner.removeRule(CalcRemoveRule.INSTANCE);
            planner.removeRule(SortRemoveRule.INSTANCE);
            for (RelOptRule rule : CalcitePrepareImpl.ENUMERABLE_RULES) {
                planner.removeRule(rule);
            }
            ArrayList<RelTraitDef> relTraitDefs = new ArrayList<RelTraitDef>(planner.getRelTraitDefs());
            planner.clearRelTraitDefs();
            for (RelTraitDef def : relTraitDefs) {
                if (def instanceof RelCollationTraitDef) continue;
                planner.addRelTraitDef(def);
            }
        });
        INSTANCE.register();
    }
}

