/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.FunctionArgumentType;
import com.google.zetasql.FunctionSignature;
import com.google.zetasql.ZetaSQLResolvedNodeKind;
import com.google.zetasql.ZetaSQLType;
import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlCalciteTranslationUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperatorMappingTable;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperators;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollations;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.AggregateCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.AggregateFunction;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlAggFunction;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class AggregateScanConverter
extends RelConverter<ResolvedNodes.ResolvedAggregateScan> {
    private static final @UnknownKeyFor @NonNull @Initialized String AVG_ILLEGAL_LONG_INPUT_TYPE = "AVG(INT64) is not supported. You might want to use AVG(CAST(expression AS FLOAT64).";

    AggregateScanConverter(@UnknownKeyFor @NonNull @Initialized ConversionContext context) {
        super(context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResolvedNode> getInputs(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ResolvedNodes.ResolvedAggregateScan zetaNode) {
        return Collections.singletonList(zetaNode.getInputScan());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RelNode convert(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ResolvedNodes.ResolvedAggregateScan zetaNode, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs) {
        Object aggregateCalls;
        LogicalProject input = this.convertAggregateScanInputScanToLogicalProject(zetaNode, inputs.get(0));
        int groupFieldsListSize = zetaNode.getGroupByList().size();
        ImmutableBitSet groupSet = groupFieldsListSize != 0 ? ImmutableBitSet.of((Iterable)IntStream.rangeClosed(0, groupFieldsListSize - 1).boxed().collect(Collectors.toList())) : ImmutableBitSet.of();
        if (zetaNode.getAggregateList().isEmpty()) {
            aggregateCalls = ImmutableList.of();
        } else {
            aggregateCalls = new ArrayList();
            int columnRefoff = groupFieldsListSize;
            for (ResolvedNodes.ResolvedComputedColumn computedColumn : zetaNode.getAggregateList()) {
                AggregateCall aggCall = this.convertAggCall(computedColumn, columnRefoff, groupSet.size(), (RelNode)input);
                aggregateCalls.add(aggCall);
                if (aggCall.getArgList().isEmpty()) continue;
                ++columnRefoff;
            }
        }
        LogicalAggregate logicalAggregate = new LogicalAggregate(this.getCluster(), input.getTraitSet(), (RelNode)input, groupSet, (List)ImmutableList.of((Object)groupSet), (List)aggregateCalls);
        return logicalAggregate;
    }

    private @UnknownKeyFor @NonNull @Initialized LogicalProject convertAggregateScanInputScanToLogicalProject(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ResolvedNodes.ResolvedAggregateScan node, @UnknownKeyFor @NonNull @Initialized RelNode input) {
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (ResolvedNodes.ResolvedComputedColumn computedColumn : node.getGroupByList()) {
            projects.add(this.getExpressionConverter().convertRexNodeFromResolvedExpr(computedColumn.getExpr(), (List<ResolvedColumn>)node.getInputScan().getColumnList(), input.getRowType().getFieldList(), (Map<String, RexNode>)ImmutableMap.of()));
            fieldNames.add(this.getTrait().resolveAlias(computedColumn.getColumn()));
        }
        for (ResolvedNodes.ResolvedComputedColumn resolvedComputedColumn : node.getAggregateList()) {
            ResolvedNodes.ResolvedAggregateFunctionCall aggregateFunctionCall = (ResolvedNodes.ResolvedAggregateFunctionCall)resolvedComputedColumn.getExpr();
            if (aggregateFunctionCall.getArgumentList() == null || aggregateFunctionCall.getArgumentList().size() < 1) continue;
            ResolvedNodes.ResolvedExpr resolvedExpr = (ResolvedNodes.ResolvedExpr)aggregateFunctionCall.getArgumentList().get(0);
            for (int i = 0; i < aggregateFunctionCall.getArgumentList().size(); ++i) {
                if (i == 0) {
                    projects.add(this.getExpressionConverter().convertRexNodeFromResolvedExpr(resolvedExpr, (List<ResolvedColumn>)node.getInputScan().getColumnList(), input.getRowType().getFieldList(), (Map<String, RexNode>)ImmutableMap.of()));
                } else {
                    projects.add(this.getExpressionConverter().convertRexNodeFromResolvedExpr((ResolvedNodes.ResolvedExpr)aggregateFunctionCall.getArgumentList().get(i)));
                }
                fieldNames.add(this.getTrait().resolveAlias(resolvedComputedColumn.getColumn()));
            }
        }
        return LogicalProject.create((RelNode)input, (List)ImmutableList.of(), projects, fieldNames);
    }

    private @UnknownKeyFor @NonNull @Initialized AggregateCall convertAggCall(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ResolvedNodes.ResolvedComputedColumn computedColumn, @UnknownKeyFor @NonNull @Initialized int columnRefOff, @UnknownKeyFor @NonNull @Initialized int groupCount, @UnknownKeyFor @NonNull @Initialized RelNode input) {
        SqlAggFunction sqlAggFunction;
        FunctionSignature signature;
        ResolvedNodes.ResolvedAggregateFunctionCall aggregateFunctionCall = (ResolvedNodes.ResolvedAggregateFunctionCall)computedColumn.getExpr();
        if (aggregateFunctionCall.getFunction().getName().equals("avg") && ((FunctionArgumentType)(signature = aggregateFunctionCall.getSignature()).getFunctionArgumentList().get(0)).getType().getKind().equals((Object)ZetaSQLType.TypeKind.TYPE_INT64)) {
            throw new UnsupportedOperationException(AVG_ILLEGAL_LONG_INPUT_TYPE);
        }
        if (aggregateFunctionCall.getDistinct()) {
            throw new UnsupportedOperationException("Does not support " + aggregateFunctionCall.getFunction().getSqlName() + " DISTINCT. 'SELECT DISTINCT' syntax could be used to deduplicate before aggregation.");
        }
        if (aggregateFunctionCall.getFunction().getGroup().equals("user_defined_java_aggregate_functions")) {
            SqlReturnTypeInference typeInference = x -> ZetaSqlCalciteTranslationUtils.toCalciteType(((FunctionSignature)aggregateFunctionCall.getFunction().getSignatureList().get(0)).getResultType().getType(), false, this.getCluster().getRexBuilder());
            UdafImpl impl = new UdafImpl((Combine.CombineFn)this.getExpressionConverter().userFunctionDefinitions.javaAggregateFunctions().get((Object)aggregateFunctionCall.getFunction().getNamePath()));
            sqlAggFunction = SqlOperators.createUdafOperator(aggregateFunctionCall.getFunction().getName(), typeInference, (AggregateFunction)impl);
        } else {
            sqlAggFunction = (SqlAggFunction)SqlOperatorMappingTable.create((ResolvedNodes.ResolvedFunctionCallBase)aggregateFunctionCall);
            if (sqlAggFunction == null) {
                throw new UnsupportedOperationException("Does not support ZetaSQL aggregate function: " + aggregateFunctionCall.getFunction().getName());
            }
        }
        ArrayList<Integer> argList = new ArrayList<Integer>();
        ResolvedNodes.ResolvedAggregateFunctionCall expr = (ResolvedNodes.ResolvedAggregateFunctionCall)computedColumn.getExpr();
        List<ZetaSQLResolvedNodeKind.ResolvedNodeKind> resolvedNodeKinds = Arrays.asList(ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CAST, ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_COLUMN_REF, ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_GET_STRUCT_FIELD);
        for (int i = 0; i < expr.getArgumentList().size(); ++i) {
            ZetaSQLResolvedNodeKind.ResolvedNodeKind resolvedNodeKind = ((ResolvedNodes.ResolvedExpr)expr.getArgumentList().get(i)).nodeKind();
            if (i == 0 && resolvedNodeKinds.contains(resolvedNodeKind)) {
                argList.add(columnRefOff);
                continue;
            }
            if (i > 0 && resolvedNodeKind == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_LITERAL) continue;
            throw new UnsupportedOperationException("Aggregate function only accepts Column Reference or CAST(Column Reference) as the first argument and Literals as subsequent arguments as its inputs");
        }
        String aggName = this.getTrait().resolveAlias(computedColumn.getColumn());
        return AggregateCall.create((SqlAggFunction)sqlAggFunction, (boolean)false, (boolean)false, (boolean)false, argList, (int)-1, null, (RelCollation)RelCollations.EMPTY, (int)groupCount, (RelNode)input, null, (String)aggName);
    }
}

