/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.LanguageOptions;
import com.google.zetasql.Value;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.CalciteQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.SqlConversionException;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.planner.RelMdNodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamCalcRule;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamUncollectRule;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamUnnestRule;
import org.apache.beam.sdk.extensions.sql.zetasql.BeamZetaSqlCalcMergeRule;
import org.apache.beam.sdk.extensions.sql.zetasql.BeamZetaSqlCalcSplittingRule;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSQLPlannerImpl;
import org.apache.beam.sdk.extensions.sql.zetasql.unnest.BeamZetaSqlUncollectRule;
import org.apache.beam.sdk.extensions.sql.zetasql.unnest.BeamZetaSqlUnnestRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCostFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RuleSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RuleSets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZetaSQLQueryPlanner
implements QueryPlanner {
    public static final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RelOptRule> DEFAULT_CALC = ImmutableList.builder().add((Object)BeamZetaSqlCalcSplittingRule.INSTANCE).build();
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ZetaSQLQueryPlanner.class);
    private final @UnknownKeyFor @NonNull @Initialized ZetaSQLPlannerImpl plannerImpl;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized QueryPlanner.Factory FACTORY = ZetaSQLQueryPlanner::new;

    public ZetaSQLQueryPlanner(@UnknownKeyFor @NonNull @Initialized FrameworkConfig config) {
        this.plannerImpl = new ZetaSQLPlannerImpl(config);
    }

    public ZetaSQLQueryPlanner(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> ruleSets) {
        this.plannerImpl = new ZetaSQLPlannerImpl(ZetaSQLQueryPlanner.defaultConfig(jdbcConnection, ZetaSQLQueryPlanner.modifyRuleSetsForZetaSql(ruleSets, DEFAULT_CALC)));
        this.setDefaultTimezone(((BeamSqlPipelineOptions)jdbcConnection.getPipelineOptions().as(BeamSqlPipelineOptions.class)).getZetaSqlDefaultTimezone());
    }

    public static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> getZetaSqlRuleSets() {
        return ZetaSQLQueryPlanner.modifyRuleSetsForZetaSql(BeamRuleSets.getRuleSets(), DEFAULT_CALC);
    }

    public static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> getZetaSqlRuleSets(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RelOptRule> calc) {
        return ZetaSQLQueryPlanner.modifyRuleSetsForZetaSql(BeamRuleSets.getRuleSets(), calc);
    }

    private static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> modifyRuleSetsForZetaSql(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> ruleSets, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RelOptRule> calc) {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (RuleSet ruleSet : ruleSets) {
            ImmutableList.Builder bd = ImmutableList.builder();
            for (RelOptRule rule : ruleSet) {
                if (rule instanceof JoinCommuteRule) continue;
                if (rule instanceof BeamCalcRule) {
                    bd.addAll(calc);
                    continue;
                }
                if (rule instanceof BeamUnnestRule) {
                    bd.add((Object)BeamZetaSqlUnnestRule.INSTANCE);
                    continue;
                }
                if (rule instanceof BeamUncollectRule) {
                    bd.add((Object)BeamZetaSqlUncollectRule.INSTANCE);
                    continue;
                }
                bd.add((Object)rule);
            }
            bd.add((Object)BeamZetaSqlCalcMergeRule.INSTANCE);
            ret.add((Object)RuleSets.ofList((Iterable)bd.build()));
        }
        return ret.build();
    }

    public @UnknownKeyFor @NonNull @Initialized String getDefaultTimezone() {
        return this.plannerImpl.getDefaultTimezone();
    }

    public void setDefaultTimezone(@UnknownKeyFor @NonNull @Initialized String timezone) {
        this.plannerImpl.setDefaultTimezone(timezone);
    }

    public static @UnknownKeyFor @NonNull @Initialized LanguageOptions getLanguageOptions() {
        return ZetaSQLPlannerImpl.getLanguageOptions();
    }

    public @UnknownKeyFor @NonNull @Initialized BeamRelNode convertToBeamRel(@UnknownKeyFor @NonNull @Initialized String sqlStatement) {
        return this.convertToBeamRel(sqlStatement, QueryPlanner.QueryParameters.ofNone());
    }

    public @UnknownKeyFor @NonNull @Initialized BeamRelNode convertToBeamRel(@UnknownKeyFor @NonNull @Initialized String sqlStatement, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> queryParams) throws @UnknownKeyFor @NonNull @Initialized ParseException, @UnknownKeyFor @NonNull @Initialized SqlConversionException {
        return this.convertToBeamRel(sqlStatement, QueryPlanner.QueryParameters.ofNamed(queryParams));
    }

    public @UnknownKeyFor @NonNull @Initialized BeamRelNode convertToBeamRel(@UnknownKeyFor @NonNull @Initialized String sqlStatement, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Value> queryParams) throws @UnknownKeyFor @NonNull @Initialized ParseException, @UnknownKeyFor @NonNull @Initialized SqlConversionException {
        return this.convertToBeamRel(sqlStatement, QueryPlanner.QueryParameters.ofPositional(queryParams));
    }

    public @UnknownKeyFor @NonNull @Initialized BeamRelNode convertToBeamRel(@UnknownKeyFor @NonNull @Initialized String sqlStatement, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters queryParameters) throws @UnknownKeyFor @NonNull @Initialized ParseException, @UnknownKeyFor @NonNull @Initialized SqlConversionException {
        return this.convertToBeamRelInternal(sqlStatement, queryParameters);
    }

    public @UnknownKeyFor @NonNull @Initialized SqlNode parse(@UnknownKeyFor @NonNull @Initialized String sqlStatement) throws @UnknownKeyFor @NonNull @Initialized ParseException {
        throw new UnsupportedOperationException(String.format("%s.parse(String) is not implemented and should need be called", this.getClass().getCanonicalName()));
    }

    private @UnknownKeyFor @NonNull @Initialized BeamRelNode convertToBeamRelInternal(@UnknownKeyFor @NonNull @Initialized String sql, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters queryParams) {
        RelRoot root = this.plannerImpl.rel(sql, queryParams);
        RelTraitSet desiredTraits = root.rel.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE).replace((RelTrait)root.collation).simplify();
        root.rel.getCluster().setMetadataProvider(ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)CalciteQueryPlanner.NonCumulativeCostImpl.SOURCE, (Object)RelMdNodeStats.SOURCE, (Object)root.rel.getCluster().getMetadataProvider())));
        root.rel.getCluster().setMetadataQuerySupplier(BeamRelMetadataQuery::instance);
        RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)root.rel.getCluster().getMetadataProvider()));
        root.rel.getCluster().invalidateMetadataQuery();
        try {
            BeamRelNode beamRelNode = (BeamRelNode)this.plannerImpl.transform(0, desiredTraits, root.rel);
            LOG.info("BEAMPlan>\n{}", BeamSqlRelUtils.explainLazily((RelNode)beamRelNode));
            return beamRelNode;
        }
        catch (RelOptPlanner.CannotPlanException e) {
            throw new SqlConversionException("Failed to produce plan for query " + sql, (Throwable)e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized FrameworkConfig defaultConfig(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> ruleSets) {
        CalciteConnectionConfig config = connection.config();
        SqlParser.ConfigBuilder parserConfig = SqlParser.configBuilder().setQuotedCasing(config.quotedCasing()).setUnquotedCasing(config.unquotedCasing()).setQuoting(config.quoting()).setConformance(config.conformance()).setCaseSensitive(config.caseSensitive());
        SqlParserImplFactory parserFactory = (SqlParserImplFactory)config.parserFactory(SqlParserImplFactory.class, null);
        if (parserFactory != null) {
            parserConfig.setParserFactory(parserFactory);
        }
        SchemaPlus schema = connection.getRootSchema();
        SchemaPlus defaultSchema = connection.getCurrentSchemaPlus();
        ImmutableList traitDefs = ImmutableList.of((Object)ConventionTraitDef.INSTANCE);
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)schema), (List)ImmutableList.of((Object)defaultSchema.getName()), (RelDataTypeFactory)connection.getTypeFactory(), connection.config());
        SqlOperatorTable opTab0 = (SqlOperatorTable)connection.config().fun(SqlOperatorTable.class, (Object)SqlStdOperatorTable.instance());
        return Frameworks.newConfigBuilder().parserConfig(parserConfig.build()).defaultSchema(defaultSchema).traitDefs((List)traitDefs).ruleSets(ruleSets.toArray(new RuleSet[0])).costFactory((RelOptCostFactory)BeamCostModel.FACTORY).typeSystem(connection.getTypeFactory().getTypeSystem()).operatorTable(SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{opTab0, catalogReader})).build();
    }
}

