/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedNode;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.QueryTrait;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ExpressionConverter;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.logical.LogicalValues;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.FrameworkConfig;

abstract class RelConverter<T extends ResolvedNode> {
    protected ConversionContext context;

    RelConverter(ConversionContext context) {
        this.context = context;
    }

    public boolean canConvert(T zetaNode) {
        return true;
    }

    public List<ResolvedNode> getInputs(T zetaNode) {
        return Collections.emptyList();
    }

    public abstract RelNode convert(T var1, List<RelNode> var2);

    protected RelOptCluster getCluster() {
        return this.context.cluster();
    }

    protected FrameworkConfig getConfig() {
        return this.context.getConfig();
    }

    protected ExpressionConverter getExpressionConverter() {
        return this.context.getExpressionConverter();
    }

    protected QueryTrait getTrait() {
        return this.context.getTrait();
    }

    static LogicalValues createOneRow(RelOptCluster cluster) {
        RelDataType rowType = cluster.getTypeFactory().builder().add("ZERO", SqlTypeName.BIGINT).nullable(false).build();
        ImmutableList tuples = ImmutableList.of((Object)ImmutableList.of((Object)cluster.getRexBuilder().makeExactLiteral(BigDecimal.ZERO, ((RelDataTypeField)rowType.getFieldList().get(0)).getType())));
        return LogicalValues.create((RelOptCluster)cluster, (RelDataType)rowType, (ImmutableList)tuples);
    }
}

