/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.common.collect.ImmutableList;
import com.google.zetasql.Analyzer;
import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.Function;
import com.google.zetasql.FunctionArgumentType;
import com.google.zetasql.FunctionSignature;
import com.google.zetasql.SimpleCatalog;
import com.google.zetasql.TVFRelation;
import com.google.zetasql.TableValuedFunction;
import com.google.zetasql.Type;
import com.google.zetasql.TypeFactory;
import com.google.zetasql.ZetaSQLBuiltinFunctionOptions;
import com.google.zetasql.ZetaSQLFunctions;
import com.google.zetasql.ZetaSQLType;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.JavaUdfLoader;
import org.apache.beam.sdk.extensions.sql.impl.LazyAggregateCombineFn;
import org.apache.beam.sdk.extensions.sql.impl.ScalarFnReflector;
import org.apache.beam.sdk.extensions.sql.impl.ScalarFunctionImpl;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.udf.ScalarFn;
import org.apache.beam.sdk.extensions.sql.zetasql.QueryTrait;
import org.apache.beam.sdk.extensions.sql.zetasql.SupportedZetaSqlBuiltinFunctions;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlCalciteTranslationUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlException;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.UserFunctionDefinitions;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.FunctionParameter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class BeamZetaSqlCatalog {
    public static final String PRE_DEFINED_WINDOW_FUNCTIONS = "pre_defined_window_functions";
    public static final String USER_DEFINED_SQL_FUNCTIONS = "user_defined_functions";
    public static final String USER_DEFINED_JAVA_SCALAR_FUNCTIONS = "user_defined_java_scalar_functions";
    public static final String USER_DEFINED_JAVA_AGGREGATE_FUNCTIONS = "user_defined_java_aggregate_functions";
    public static final String ZETASQL_FUNCTION_GROUP_NAME = "ZetaSQL";
    private static final ImmutableList<String> PRE_DEFINED_WINDOW_FUNCTION_DECLARATIONS = ImmutableList.of((Object)"CREATE FUNCTION TUMBLE(ts TIMESTAMP, window_size STRING) AS (1);", (Object)"CREATE FUNCTION TUMBLE_START(window_size STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION TUMBLE_END(window_size STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION HOP(ts TIMESTAMP, emit_frequency STRING, window_size STRING) AS (1);", (Object)"CREATE FUNCTION HOP_START(emit_frequency STRING, window_size STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION HOP_END(emit_frequency STRING, window_size STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION SESSION(ts TIMESTAMP, session_gap STRING) AS (1);", (Object)"CREATE FUNCTION SESSION_START(session_gap STRING) RETURNS TIMESTAMP AS (null);", (Object)"CREATE FUNCTION SESSION_END(session_gap STRING) RETURNS TIMESTAMP AS (null);");
    private final SchemaPlus calciteSchema;
    private final SimpleCatalog zetaSqlCatalog;
    private final JavaTypeFactory typeFactory;
    private final JavaUdfLoader javaUdfLoader = new JavaUdfLoader();
    private final Map<List<String>, ResolvedNodes.ResolvedCreateFunctionStmt> sqlScalarUdfs = new HashMap<List<String>, ResolvedNodes.ResolvedCreateFunctionStmt>();
    private final Map<List<String>, ResolvedNode> sqlUdtvfs = new HashMap<List<String>, ResolvedNode>();
    private final Map<List<String>, UserFunctionDefinitions.JavaScalarFunction> javaScalarUdfs = new HashMap<List<String>, UserFunctionDefinitions.JavaScalarFunction>();
    private final Map<List<String>, Combine.CombineFn<?, ?, ?>> javaUdafs = new HashMap();

    private BeamZetaSqlCatalog(SchemaPlus calciteSchema, SimpleCatalog zetaSqlCatalog, JavaTypeFactory typeFactory) {
        this.calciteSchema = calciteSchema;
        this.zetaSqlCatalog = zetaSqlCatalog;
        this.typeFactory = typeFactory;
    }

    static BeamZetaSqlCatalog create(SchemaPlus calciteSchema, JavaTypeFactory typeFactory, AnalyzerOptions options) {
        BeamZetaSqlCatalog catalog = new BeamZetaSqlCatalog(calciteSchema, new SimpleCatalog(calciteSchema.getName()), typeFactory);
        catalog.addFunctionsToCatalog(options);
        return catalog;
    }

    SimpleCatalog getZetaSqlCatalog() {
        return this.zetaSqlCatalog;
    }

    void addTables(List<List<String>> tables, QueryTrait queryTrait) {
        tables.forEach(table -> this.addTableToLeafCatalog((List<String>)table, queryTrait));
    }

    void addFunction(ResolvedNodes.ResolvedCreateFunctionStmt createFunctionStmt) {
        String functionGroup;
        switch (functionGroup = this.getFunctionGroup(createFunctionStmt)) {
            case "user_defined_functions": {
                this.sqlScalarUdfs.put((List<String>)createFunctionStmt.getNamePath(), createFunctionStmt);
                break;
            }
            case "user_defined_java_scalar_functions": {
                String functionName = String.join((CharSequence)".", (Iterable<? extends CharSequence>)createFunctionStmt.getNamePath());
                for (FunctionArgumentType argumentType : createFunctionStmt.getSignature().getFunctionArgumentList()) {
                    Type type = argumentType.getType();
                    if (type == null) {
                        throw new UnsupportedOperationException("UDF templated argument types are not supported.");
                    }
                    this.validateJavaUdfZetaSqlType(type, functionName);
                }
                if (createFunctionStmt.getReturnType() == null) {
                    throw new IllegalArgumentException("UDF return type must not be null.");
                }
                this.validateJavaUdfZetaSqlType(createFunctionStmt.getReturnType(), functionName);
                String jarPath = BeamZetaSqlCatalog.getJarPath(createFunctionStmt);
                ScalarFn scalarFn = this.javaUdfLoader.loadScalarFunction((List)createFunctionStmt.getNamePath(), jarPath);
                Method method = ScalarFnReflector.getApplyMethod((ScalarFn)scalarFn);
                this.javaScalarUdfs.put((List<String>)createFunctionStmt.getNamePath(), UserFunctionDefinitions.JavaScalarFunction.create(method, jarPath));
                break;
            }
            case "user_defined_java_aggregate_functions": {
                String jarPath = BeamZetaSqlCatalog.getJarPath(createFunctionStmt);
                this.javaUdfLoader.loadAggregateFunction((List)createFunctionStmt.getNamePath(), jarPath);
                LazyAggregateCombineFn combineFn = new LazyAggregateCombineFn((List)createFunctionStmt.getNamePath(), jarPath);
                this.javaUdafs.put((List<String>)createFunctionStmt.getNamePath(), (Combine.CombineFn<?, ?, ?>)combineFn);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Encountered unrecognized function group %s.", functionGroup));
            }
        }
        this.zetaSqlCatalog.addFunction(new Function((List)createFunctionStmt.getNamePath(), functionGroup, createFunctionStmt.getIsAggregate() ? ZetaSQLFunctions.FunctionEnums.Mode.AGGREGATE : ZetaSQLFunctions.FunctionEnums.Mode.SCALAR, (List)ImmutableList.of((Object)createFunctionStmt.getSignature())));
    }

    void validateJavaUdfZetaSqlType(Type type, String functionName) {
        switch (type.getKind()) {
            case TYPE_BOOL: 
            case TYPE_BYTES: 
            case TYPE_DATE: 
            case TYPE_DOUBLE: 
            case TYPE_INT64: 
            case TYPE_NUMERIC: 
            case TYPE_STRING: 
            case TYPE_TIMESTAMP: {
                break;
            }
            case TYPE_ARRAY: {
                this.validateJavaUdfZetaSqlType(type.asArray().getElementType(), functionName);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("ZetaSQL type %s not allowed in function %s", type.getKind().name(), functionName));
            }
        }
    }

    void addTableValuedFunction(ResolvedNodes.ResolvedCreateTableFunctionStmt createTableFunctionStmt) {
        this.zetaSqlCatalog.addTableValuedFunction((TableValuedFunction)new TableValuedFunction.FixedOutputSchemaTVF(createTableFunctionStmt.getNamePath(), createTableFunctionStmt.getSignature(), TVFRelation.createColumnBased(createTableFunctionStmt.getQuery().getColumnList().stream().map(c -> TVFRelation.Column.create((String)c.getName(), (Type)c.getType())).collect(Collectors.toList()))));
        this.sqlUdtvfs.put((List<String>)createTableFunctionStmt.getNamePath(), (ResolvedNode)createTableFunctionStmt.getQuery());
    }

    UserFunctionDefinitions getUserFunctionDefinitions() {
        return UserFunctionDefinitions.newBuilder().setSqlScalarFunctions((ImmutableMap<List<String>, ResolvedNodes.ResolvedCreateFunctionStmt>)ImmutableMap.copyOf(this.sqlScalarUdfs)).setSqlTableValuedFunctions((ImmutableMap<List<String>, ResolvedNode>)ImmutableMap.copyOf(this.sqlUdtvfs)).setJavaScalarFunctions((ImmutableMap<List<String>, UserFunctionDefinitions.JavaScalarFunction>)ImmutableMap.copyOf(this.javaScalarUdfs)).setJavaAggregateFunctions(ImmutableMap.copyOf(this.javaUdafs)).build();
    }

    private void addFunctionsToCatalog(AnalyzerOptions options) {
        ZetaSQLBuiltinFunctionOptions zetasqlBuiltinFunctionOptions = new ZetaSQLBuiltinFunctionOptions(options.getLanguageOptions());
        SupportedZetaSqlBuiltinFunctions.ALLOWLIST.forEach(arg_0 -> ((ZetaSQLBuiltinFunctionOptions)zetasqlBuiltinFunctionOptions).includeFunctionSignatureId(arg_0));
        this.zetaSqlCatalog.addZetaSQLFunctions(zetasqlBuiltinFunctionOptions);
        this.addWindowScalarFunctions(options);
        this.addWindowTvfs();
        this.addUdfsFromSchema();
    }

    private void addWindowScalarFunctions(AnalyzerOptions options) {
        PRE_DEFINED_WINDOW_FUNCTION_DECLARATIONS.stream().map(func -> (ResolvedNodes.ResolvedCreateFunctionStmt)Analyzer.analyzeStatement((String)func, (AnalyzerOptions)options, (SimpleCatalog)this.zetaSqlCatalog)).map(resolvedFunc -> new Function(String.join((CharSequence)".", (Iterable<? extends CharSequence>)resolvedFunc.getNamePath()), PRE_DEFINED_WINDOW_FUNCTIONS, ZetaSQLFunctions.FunctionEnums.Mode.SCALAR, (List)ImmutableList.of((Object)resolvedFunc.getSignature()))).forEach(arg_0 -> ((SimpleCatalog)this.zetaSqlCatalog).addFunction(arg_0));
    }

    private void addWindowTvfs() {
        FunctionArgumentType retType = new FunctionArgumentType(ZetaSQLFunctions.SignatureArgumentKind.ARG_TYPE_RELATION);
        FunctionArgumentType inputTableType = new FunctionArgumentType(ZetaSQLFunctions.SignatureArgumentKind.ARG_TYPE_RELATION);
        FunctionArgumentType descriptorType = new FunctionArgumentType(ZetaSQLFunctions.SignatureArgumentKind.ARG_TYPE_DESCRIPTOR, FunctionArgumentType.FunctionArgumentTypeOptions.builder().setDescriptorResolutionTableOffset(Integer.valueOf(0)).build(), 1);
        FunctionArgumentType stringType = new FunctionArgumentType((Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING));
        this.zetaSqlCatalog.addTableValuedFunction((TableValuedFunction)new TableValuedFunction.ForwardInputSchemaToOutputSchemaWithAppendedColumnTVF(ImmutableList.of((Object)"TUMBLE"), new FunctionSignature(retType, (List)ImmutableList.of((Object)inputTableType, (Object)descriptorType, (Object)stringType), -1L), ImmutableList.of((Object)TVFRelation.Column.create((String)"window_start", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP)), (Object)TVFRelation.Column.create((String)"window_end", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP))), null, null));
        this.zetaSqlCatalog.addTableValuedFunction((TableValuedFunction)new TableValuedFunction.ForwardInputSchemaToOutputSchemaWithAppendedColumnTVF(ImmutableList.of((Object)"HOP"), new FunctionSignature(retType, (List)ImmutableList.of((Object)inputTableType, (Object)descriptorType, (Object)stringType, (Object)stringType), -1L), ImmutableList.of((Object)TVFRelation.Column.create((String)"window_start", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP)), (Object)TVFRelation.Column.create((String)"window_end", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP))), null, null));
        this.zetaSqlCatalog.addTableValuedFunction((TableValuedFunction)new TableValuedFunction.ForwardInputSchemaToOutputSchemaWithAppendedColumnTVF(ImmutableList.of((Object)"SESSION"), new FunctionSignature(retType, (List)ImmutableList.of((Object)inputTableType, (Object)descriptorType, (Object)descriptorType, (Object)stringType), -1L), ImmutableList.of((Object)TVFRelation.Column.create((String)"window_start", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP)), (Object)TVFRelation.Column.create((String)"window_end", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP))), null, null));
    }

    private void addUdfsFromSchema() {
        for (String functionName : this.calciteSchema.getFunctionNames()) {
            Collection functions = this.calciteSchema.getFunctions(functionName);
            if (functions.size() != 1) {
                throw new IllegalArgumentException(String.format("Expected exactly 1 definition for function '%s', but found %d. Beam ZetaSQL supports only a single function definition per function name (BEAM-12073).", functionName, functions.size()));
            }
            for (org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Function function : functions) {
                List<String> path = Arrays.asList(functionName.split("\\."));
                if (function instanceof ScalarFunctionImpl) {
                    ScalarFunctionImpl scalarFunction = (ScalarFunctionImpl)function;
                    for (FunctionParameter parameter : scalarFunction.getParameters()) {
                        this.validateJavaUdfCalciteType(parameter.getType((RelDataTypeFactory)this.typeFactory), functionName);
                    }
                    this.validateJavaUdfCalciteType(scalarFunction.getReturnType((RelDataTypeFactory)this.typeFactory), functionName);
                    Method method = scalarFunction.method;
                    this.javaScalarUdfs.put(path, UserFunctionDefinitions.JavaScalarFunction.create(method, ""));
                    FunctionArgumentType resultType = new FunctionArgumentType(ZetaSqlCalciteTranslationUtils.toZetaSqlType(scalarFunction.getReturnType((RelDataTypeFactory)this.typeFactory)));
                    FunctionSignature functionSignature = new FunctionSignature(resultType, this.getArgumentTypes((org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Function)scalarFunction), 0L);
                    this.zetaSqlCatalog.addFunction(new Function(path, USER_DEFINED_JAVA_SCALAR_FUNCTIONS, ZetaSQLFunctions.FunctionEnums.Mode.SCALAR, (List)ImmutableList.of((Object)functionSignature)));
                    continue;
                }
                if (function instanceof UdafImpl) {
                    UdafImpl udaf = (UdafImpl)function;
                    this.javaUdafs.put(path, udaf.getCombineFn());
                    FunctionArgumentType resultType = new FunctionArgumentType(ZetaSqlCalciteTranslationUtils.toZetaSqlType(udaf.getReturnType((RelDataTypeFactory)this.typeFactory)));
                    FunctionSignature functionSignature = new FunctionSignature(resultType, this.getArgumentTypes((org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Function)udaf), 0L);
                    this.zetaSqlCatalog.addFunction(new Function(path, USER_DEFINED_JAVA_AGGREGATE_FUNCTIONS, ZetaSQLFunctions.FunctionEnums.Mode.AGGREGATE, (List)ImmutableList.of((Object)functionSignature)));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Function %s has unrecognized implementation type %s.", functionName, function.getClass().getName()));
            }
        }
    }

    private List<FunctionArgumentType> getArgumentTypes(org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Function function) {
        return function.getParameters().stream().map(arg -> new FunctionArgumentType(ZetaSqlCalciteTranslationUtils.toZetaSqlType(arg.getType((RelDataTypeFactory)this.typeFactory)))).collect(Collectors.toList());
    }

    private void validateJavaUdfCalciteType(RelDataType type, String functionName) {
        switch (type.getSqlTypeName()) {
            case BIGINT: 
            case BOOLEAN: 
            case DATE: 
            case DECIMAL: 
            case DOUBLE: 
            case TIMESTAMP: 
            case VARCHAR: 
            case VARBINARY: {
                break;
            }
            case ARRAY: {
                this.validateJavaUdfCalciteType((RelDataType)Preconditions.checkArgumentNotNull((Object)type.getComponentType(), (Object)"Encountered ARRAY type with no component type."), functionName);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Calcite type %s not allowed in function %s", type.getSqlTypeName().getName(), functionName));
            }
        }
    }

    private String getFunctionGroup(ResolvedNodes.ResolvedCreateFunctionStmt createFunctionStmt) {
        switch (createFunctionStmt.getLanguage().toUpperCase()) {
            case "JAVA": {
                return createFunctionStmt.getIsAggregate() ? USER_DEFINED_JAVA_AGGREGATE_FUNCTIONS : USER_DEFINED_JAVA_SCALAR_FUNCTIONS;
            }
            case "SQL": {
                if (createFunctionStmt.getIsAggregate()) {
                    throw new UnsupportedOperationException("Native SQL aggregate functions are not supported (BEAM-9954).");
                }
                return USER_DEFINED_SQL_FUNCTIONS;
            }
            case "PY": 
            case "PYTHON": 
            case "JS": 
            case "JAVASCRIPT": {
                throw new UnsupportedOperationException(String.format("Function %s uses unsupported language %s.", String.join((CharSequence)".", (Iterable<? extends CharSequence>)createFunctionStmt.getNamePath()), createFunctionStmt.getLanguage()));
            }
        }
        throw new IllegalArgumentException(String.format("Function %s uses unrecognized language %s.", String.join((CharSequence)".", (Iterable<? extends CharSequence>)createFunctionStmt.getNamePath()), createFunctionStmt.getLanguage()));
    }

    private void addTableToLeafCatalog(List<String> tablePath, QueryTrait queryTrait) {
        SimpleCatalog leafCatalog = BeamZetaSqlCatalog.createNestedCatalogs(this.zetaSqlCatalog, tablePath);
        Table calciteTable = TableResolution.resolveCalciteTable(this.calciteSchema, tablePath);
        if (calciteTable == null) {
            throw new ZetaSqlException("Wasn't able to resolve the path " + tablePath + " in schema: " + this.calciteSchema.getName());
        }
        RelDataType rowType = calciteTable.getRowType((RelDataTypeFactory)this.typeFactory);
        TableResolution.SimpleTableWithPath tableWithPath = TableResolution.SimpleTableWithPath.of(tablePath);
        queryTrait.addResolvedTable(tableWithPath);
        BeamZetaSqlCatalog.addFieldsToTable(tableWithPath, rowType);
        leafCatalog.addSimpleTable(tableWithPath.getTable());
    }

    private static void addFieldsToTable(TableResolution.SimpleTableWithPath tableWithPath, RelDataType rowType) {
        for (RelDataTypeField field : rowType.getFieldList()) {
            tableWithPath.getTable().addSimpleColumn(field.getName(), ZetaSqlCalciteTranslationUtils.toZetaSqlType(field.getType()));
        }
    }

    private static SimpleCatalog createNestedCatalogs(SimpleCatalog catalog, List<String> tablePath) {
        SimpleCatalog currentCatalog = catalog;
        for (int i = 0; i < tablePath.size() - 1; ++i) {
            String nextCatalogName = tablePath.get(i);
            Optional<SimpleCatalog> existing = BeamZetaSqlCatalog.tryGetExisting(currentCatalog, nextCatalogName);
            currentCatalog = existing.isPresent() ? existing.get() : BeamZetaSqlCatalog.addNewCatalog(currentCatalog, nextCatalogName);
        }
        return currentCatalog;
    }

    private static Optional<SimpleCatalog> tryGetExisting(SimpleCatalog currentCatalog, String nextCatalogName) {
        return currentCatalog.getCatalogList().stream().filter(c -> nextCatalogName.equals(c.getFullName())).findFirst();
    }

    private static SimpleCatalog addNewCatalog(SimpleCatalog currentCatalog, String nextCatalogName) {
        SimpleCatalog nextCatalog = new SimpleCatalog(nextCatalogName);
        currentCatalog.addSimpleCatalog(nextCatalog);
        return nextCatalog;
    }

    private static String getJarPath(ResolvedNodes.ResolvedCreateFunctionStmt createFunctionStmt) {
        String jarPath = BeamZetaSqlCatalog.getOptionStringValue(createFunctionStmt, "path");
        if (jarPath.isEmpty()) {
            throw new IllegalArgumentException(String.format("No jar was provided to define function %s. Add 'OPTIONS (path=<jar location>)' to the CREATE FUNCTION statement.", String.join((CharSequence)".", (Iterable<? extends CharSequence>)createFunctionStmt.getNamePath())));
        }
        return jarPath;
    }

    private static String getOptionStringValue(ResolvedNodes.ResolvedCreateFunctionStmt createFunctionStmt, String optionName) {
        for (ResolvedNodes.ResolvedOption option : createFunctionStmt.getOptionList()) {
            if (!optionName.equals(option.getName())) continue;
            if (option.getValue() == null) {
                throw new IllegalArgumentException(String.format("Option '%s' has null value (expected %s).", optionName, ZetaSQLType.TypeKind.TYPE_STRING));
            }
            if (option.getValue().getType().getKind() != ZetaSQLType.TypeKind.TYPE_STRING) {
                throw new IllegalArgumentException(String.format("Option '%s' has type %s (expected %s).", optionName, option.getValue().getType().getKind(), ZetaSQLType.TypeKind.TYPE_STRING));
            }
            return ((ResolvedNodes.ResolvedLiteral)option.getValue()).getValue().getStringValue();
        }
        return "";
    }
}

