/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.zetasql.QueryTrait;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ExpressionConverter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.FrameworkConfig;

@Internal
public class ConversionContext {
    private final FrameworkConfig config;
    private final ExpressionConverter expressionConverter;
    private final RelOptCluster cluster;
    private final QueryTrait trait;
    private final Map<List<String>, ResolvedNode> userDefinedTableValuedFunctions;
    private Map<String, RexNode> functionArgumentRefMapping;

    public static ConversionContext of(FrameworkConfig config, ExpressionConverter expressionConverter, RelOptCluster cluster, QueryTrait trait, Map<List<String>, ResolvedNode> sqlUDTVF) {
        return new ConversionContext(config, expressionConverter, cluster, trait, sqlUDTVF);
    }

    public static ConversionContext of(FrameworkConfig config, ExpressionConverter expressionConverter, RelOptCluster cluster, QueryTrait trait) {
        return new ConversionContext(config, expressionConverter, cluster, trait, Collections.emptyMap());
    }

    private ConversionContext(FrameworkConfig config, ExpressionConverter expressionConverter, RelOptCluster cluster, QueryTrait trait, Map<List<String>, ResolvedNode> sqlUDTVF) {
        this.config = config;
        this.expressionConverter = expressionConverter;
        this.cluster = cluster;
        this.trait = trait;
        this.userDefinedTableValuedFunctions = sqlUDTVF;
        this.functionArgumentRefMapping = new HashMap<String, RexNode>();
    }

    FrameworkConfig getConfig() {
        return this.config;
    }

    ExpressionConverter getExpressionConverter() {
        return this.expressionConverter;
    }

    RelOptCluster cluster() {
        return this.cluster;
    }

    QueryTrait getTrait() {
        return this.trait;
    }

    Map<List<String>, ResolvedNode> getUserDefinedTableValuedFunctions() {
        return this.userDefinedTableValuedFunctions;
    }

    Map<String, RexNode> getFunctionArgumentRefMapping() {
        return this.functionArgumentRefMapping;
    }

    void addToFunctionArgumentRefMapping(String s, RexNode r) {
        this.getFunctionArgumentRefMapping().put(s, r);
    }

    void clearFunctionArgumentRefMapping() {
        this.getFunctionArgumentRefMapping().clear();
    }
}

