/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Uncollect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class ArrayScanColumnRefToUncollect
extends RelConverter<ResolvedNodes.ResolvedArrayScan> {
    ArrayScanColumnRefToUncollect(ConversionContext context) {
        super(context);
    }

    @Override
    public boolean canConvert(ResolvedNodes.ResolvedArrayScan zetaNode) {
        return zetaNode.getInputScan() != null && zetaNode.getArrayExpr() instanceof ResolvedNodes.ResolvedColumnRef && zetaNode.getJoinExpr() == null;
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedArrayScan zetaNode) {
        return ImmutableList.of((Object)zetaNode.getInputScan());
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedArrayScan zetaNode, List<RelNode> inputs) {
        assert (inputs.size() == 1);
        RelNode input = inputs.get(0);
        RexInputRef columnRef = (RexInputRef)this.getExpressionConverter().convertRexNodeFromResolvedExpr(zetaNode.getArrayExpr(), (List<ResolvedColumn>)zetaNode.getInputScan().getColumnList(), input.getRowType().getFieldList(), (Map<String, RexNode>)ImmutableMap.of());
        String fieldName = String.format("%s%s", zetaNode.getElementColumn().getTableName(), zetaNode.getElementColumn().getName());
        CorrelationId correlationId = new CorrelationId(0);
        LogicalProject projectNode = LogicalProject.create((RelNode)ArrayScanColumnRefToUncollect.createOneRow(this.getCluster()), Collections.singletonList(this.getCluster().getRexBuilder().makeFieldAccess(this.getCluster().getRexBuilder().makeCorrel(input.getRowType(), correlationId), columnRef.getIndex())), (List)ImmutableList.of((Object)fieldName));
        boolean ordinality = zetaNode.getArrayOffsetColumn() != null;
        Uncollect uncollect = Uncollect.create((RelTraitSet)projectNode.getTraitSet(), (RelNode)projectNode, (boolean)ordinality);
        return LogicalCorrelate.create((RelNode)input, (RelNode)uncollect, (CorrelationId)correlationId, (ImmutableBitSet)ImmutableBitSet.of((int[])new int[]{columnRef.getIndex()}), (JoinRelType)JoinRelType.INNER);
    }
}

