/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.PreparedExpression;
import com.google.zetasql.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.rel.AbstractBeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamBigQuerySqlDialect;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamSqlUnparseContext;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlAnalyzer;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlBeamTranslationUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

@Internal
public class BeamZetaSqlCalcRel
extends AbstractBeamCalcRel {
    private static final SqlDialect DIALECT = BeamBigQuerySqlDialect.DEFAULT;
    private final SqlImplementor.Context context;

    private static String columnName(int i) {
        return "_" + i;
    }

    public BeamZetaSqlCalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexProgram program) {
        super(cluster, traits, input, program);
        IntFunction<SqlNode> fn = i -> new SqlIdentifier(BeamZetaSqlCalcRel.columnName(i), SqlParserPos.ZERO);
        this.context = new BeamSqlUnparseContext(fn);
    }

    public Calc copy(RelTraitSet traitSet, RelNode input, RexProgram program) {
        return new BeamZetaSqlCalcRel(this.getCluster(), traitSet, input, program);
    }

    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private static class CalcFn
    extends DoFn<Row, Row> {
        private final String sql;
        private final Schema inputSchema;
        private final Schema outputSchema;
        private final boolean verifyRowValues;
        private transient PreparedExpression exp;

        CalcFn(String sql, Schema inputSchema, Schema outputSchema, boolean verifyRowValues) {
            this.sql = sql;
            this.inputSchema = inputSchema;
            this.outputSchema = outputSchema;
            this.verifyRowValues = verifyRowValues;
        }

        @DoFn.Setup
        public void setup() {
            AnalyzerOptions options = SqlAnalyzer.initAnalyzerOptions();
            for (int i = 0; i < this.inputSchema.getFieldCount(); ++i) {
                options.addExpressionColumn(BeamZetaSqlCalcRel.columnName(i), ZetaSqlBeamTranslationUtils.beamFieldTypeToZetaSqlType(this.inputSchema.getField(i).getType()));
            }
            this.exp = new PreparedExpression(this.sql);
            this.exp.prepare(options);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            HashMap<String, Value> columns = new HashMap<String, Value>();
            Row row = (Row)c.element();
            for (int i = 0; i < this.inputSchema.getFieldCount(); ++i) {
                columns.put(BeamZetaSqlCalcRel.columnName(i), ZetaSqlBeamTranslationUtils.javaObjectToZetaSqlValue(row.getBaseValue(i, Object.class), this.inputSchema.getField(i).getType()));
            }
            Map params = Collections.emptyMap();
            Value v = this.exp.execute(columns, params);
            if (!v.isNull()) {
                Row outputRow = ZetaSqlBeamTranslationUtils.zetaSqlStructValueToBeamRow(v, this.outputSchema, this.verifyRowValues);
                c.output((Object)outputRow);
            }
        }

        @DoFn.Teardown
        public void teardown() {
            this.exp.close();
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"%s expected a single input PCollection, but received %d.", (Object)BeamZetaSqlCalcRel.class.getSimpleName(), (int)pinput.size());
            PCollection upstream = pinput.get(0);
            RexBuilder rexBuilder = BeamZetaSqlCalcRel.this.getCluster().getRexBuilder();
            RexNode rex = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ROW, BeamZetaSqlCalcRel.this.getProgram().getProjectList());
            RexLocalRef condition = BeamZetaSqlCalcRel.this.getProgram().getCondition();
            if (condition != null) {
                rex = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{condition, rex, rexBuilder.makeNullLiteral(BeamZetaSqlCalcRel.this.getRowType())});
            }
            boolean verifyRowValues = ((BeamSqlPipelineOptions)pinput.getPipeline().getOptions().as(BeamSqlPipelineOptions.class)).getVerifyRowValues();
            Schema outputSchema = CalciteUtils.toSchema((RelDataType)BeamZetaSqlCalcRel.this.getRowType());
            CalcFn calcFn = new CalcFn(BeamZetaSqlCalcRel.this.context.toSql(BeamZetaSqlCalcRel.this.getProgram(), rex).toSqlString(DIALECT).getSql(), upstream.getSchema(), outputSchema, verifyRowValues);
            calcFn.setup();
            return ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)calcFn))).setRowSchema(outputSchema);
        }
    }
}

