/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelCollation;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelCollations;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalSort;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

class LimitOffsetScanToLimitConverter
extends RelConverter<ResolvedNodes.ResolvedLimitOffsetScan> {
    LimitOffsetScanToLimitConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public boolean canConvert(ResolvedNodes.ResolvedLimitOffsetScan zetaNode) {
        return !(zetaNode.getInputScan() instanceof ResolvedNodes.ResolvedOrderByScan);
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedLimitOffsetScan zetaNode) {
        return Collections.singletonList(zetaNode.getInputScan());
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedLimitOffsetScan zetaNode, List<RelNode> inputs) {
        RelNode input = inputs.get(0);
        RelCollation relCollation = RelCollations.of((List)ImmutableList.of());
        RexNode offset = zetaNode.getOffset() == null ? null : this.getExpressionConverter().convertRexNodeFromResolvedExpr(zetaNode.getOffset());
        RexNode fetch = this.getExpressionConverter().convertRexNodeFromResolvedExpr(zetaNode.getLimit(), (List<ResolvedColumn>)zetaNode.getColumnList(), input.getRowType().getFieldList());
        if (RexLiteral.isNullLiteral((RexNode)offset) || RexLiteral.isNullLiteral((RexNode)fetch)) {
            throw new UnsupportedOperationException("Limit requires non-null count and offset");
        }
        return LogicalSort.create((RelNode)input, (RelCollation)relCollation, (RexNode)offset, (RexNode)fetch);
    }
}

