/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.Analyzer;
import com.google.zetasql.LanguageOptions;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.io.Reader;
import java.util.List;
import java.util.logging.Logger;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.zetasql.QueryTrait;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlAnalyzer;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ExpressionConverter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.QueryStatementConverter;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexExecutor;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Planner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Program;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.ValidationException;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.Util;

public class ZetaSQLPlannerImpl
implements Planner {
    private static final Logger LOG = Logger.getLogger(ZetaSQLPlannerImpl.class.getName());
    private final SchemaPlus defaultSchemaPlus;
    private final FrameworkConfig config;
    private RelOptPlanner planner;
    private JavaTypeFactory typeFactory;
    private final RexExecutor executor;
    private RelOptCluster cluster;
    private final ImmutableList<Program> programs;
    private ExpressionConverter expressionConverter;
    private static final long ONE_SECOND_IN_MILLIS = 1000L;
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private static final long ONE_HOUR_IN_MILLIS = 3600000L;
    private static final long ONE_DAY_IN_MILLIS = 86400000L;
    private static final long ONE_MONTH_IN_MILLIS = 2592000000L;
    private static final long ONE_YEAR_IN_MILLIS = 31536000000L;

    public ZetaSQLPlannerImpl(FrameworkConfig config) {
        this.config = config;
        this.executor = config.getExecutor();
        this.programs = config.getPrograms();
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            Util.discard((Object)rootSchema);
            this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
            this.planner = cluster.getPlanner();
            this.planner.setExecutor(this.executor);
            return null;
        }, (FrameworkConfig)config);
        this.defaultSchemaPlus = config.getDefaultSchema();
    }

    public SqlNode parse(String s) throws SqlParseException {
        throw new UnsupportedOperationException(String.format("%s.parse(String) is not implemented", this.getClass().getCanonicalName()));
    }

    public SqlNode parse(Reader reader) throws SqlParseException {
        throw new UnsupportedOperationException(String.format("%s.parse(Reader) is not implemented", this.getClass().getCanonicalName()));
    }

    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        throw new UnsupportedOperationException(String.format("%s.validate(SqlNode) is not implemented", this.getClass().getCanonicalName()));
    }

    public Pair<SqlNode, RelDataType> validateAndGetType(SqlNode sqlNode) throws ValidationException {
        throw new UnsupportedOperationException(String.format("%s.validateAndGetType(SqlNode) is not implemented", this.getClass().getCanonicalName()));
    }

    public RelRoot rel(SqlNode sqlNode) throws RelConversionException {
        throw new UnsupportedOperationException(String.format("%s.rel(SqlNode) is not implemented", this.getClass().getCanonicalName()));
    }

    public RelRoot rel(String sql, QueryPlanner.QueryParameters params) {
        this.cluster = RelOptCluster.create((RelOptPlanner)this.planner, (RexBuilder)new RexBuilder((RelDataTypeFactory)this.typeFactory));
        this.expressionConverter = new ExpressionConverter(this.cluster, params);
        QueryTrait trait = new QueryTrait();
        List tables = Analyzer.extractTableNamesFromStatement((String)sql);
        TableResolution.registerTables(this.defaultSchemaPlus, tables);
        ResolvedNodes.ResolvedStatement statement = SqlAnalyzer.getBuilder().withQueryParams(params).withQueryTrait(trait).withCalciteContext(this.config.getContext()).withTopLevelSchema(this.defaultSchemaPlus).withTypeFactory((JavaTypeFactory)this.cluster.getTypeFactory()).analyze(sql);
        if (!(statement instanceof ResolvedNodes.ResolvedQueryStmt)) {
            throw new UnsupportedOperationException("Unsupported query statement type: " + sql.getClass().getSimpleName());
        }
        ConversionContext context = ConversionContext.of(this.config, this.expressionConverter, this.cluster, trait);
        RelNode convertedNode = QueryStatementConverter.convertRootQuery(context, (ResolvedNodes.ResolvedQueryStmt)statement);
        return RelRoot.of((RelNode)convertedNode, (SqlKind)SqlKind.ALL);
    }

    public RelNode convert(SqlNode sqlNode) {
        throw new UnsupportedOperationException(String.format("%s.convert(SqlNode) is not implemented.", this.getClass().getCanonicalName()));
    }

    public RelDataTypeFactory getTypeFactory() {
        throw new UnsupportedOperationException(String.format("%s.getTypeFactor() is not implemented.", this.getClass().getCanonicalName()));
    }

    public RelNode transform(int i, RelTraitSet relTraitSet, RelNode relNode) throws RelConversionException {
        Program program = (Program)this.programs.get(i);
        return program.run(this.planner, relNode, relTraitSet, (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    public void reset() {
        throw new UnsupportedOperationException(String.format("%s.reset() is not implemented", this.getClass().getCanonicalName()));
    }

    public void close() {
    }

    public RelTraitSet getEmptyTraitSet() {
        throw new UnsupportedOperationException(String.format("%s.getEmptyTraitSet() is not implemented", this.getClass().getCanonicalName()));
    }

    public static LanguageOptions getLanguageOptions() {
        return SqlAnalyzer.initAnalyzerOptions().getLanguageOptions();
    }
}

