/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.zetasql.ArrayType;
import com.google.zetasql.StructType;
import com.google.zetasql.Type;
import com.google.zetasql.TypeFactory;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.math.LongMath;
import org.joda.time.Instant;

@Internal
public final class ZetaSqlUtils {
    private static final long MICROS_PER_MILLI = 1000L;

    private ZetaSqlUtils() {
    }

    public static SqlTypeName zetaSqlTypeToCalciteType(ZetaSQLType.TypeKind zetaSqlType) {
        switch (zetaSqlType) {
            case TYPE_INT64: {
                return SqlTypeName.BIGINT;
            }
            case TYPE_NUMERIC: {
                return SqlTypeName.DECIMAL;
            }
            case TYPE_DOUBLE: {
                return SqlTypeName.DOUBLE;
            }
            case TYPE_STRING: {
                return SqlTypeName.VARCHAR;
            }
            case TYPE_TIMESTAMP: {
                return SqlTypeName.TIMESTAMP;
            }
            case TYPE_BOOL: {
                return SqlTypeName.BOOLEAN;
            }
            case TYPE_BYTES: {
                return SqlTypeName.VARBINARY;
            }
        }
        throw new IllegalArgumentException("Unsupported ZetaSQL type: " + zetaSqlType.name());
    }

    public static Type beamFieldTypeToZetaSqlType(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT64: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64);
            }
            case DECIMAL: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_NUMERIC);
            }
            case DOUBLE: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DOUBLE);
            }
            case STRING: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING);
            }
            case DATETIME: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP);
            }
            case BOOLEAN: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BOOL);
            }
            case BYTES: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BYTES);
            }
            case ARRAY: {
                return ZetaSqlUtils.createZetaSqlArrayTypeFromBeamElementFieldType(fieldType.getCollectionElementType());
            }
            case ROW: {
                return ZetaSqlUtils.createZetaSqlStructTypeFromBeamSchema(fieldType.getRowSchema());
            }
            case LOGICAL_TYPE: {
                switch (fieldType.getLogicalType().getIdentifier()) {
                    case "SqlDateType": {
                        return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DATE);
                    }
                    case "SqlTimeType": {
                        return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIME);
                    }
                }
                throw new IllegalArgumentException("Unsupported Beam logical type: " + fieldType.getLogicalType().getIdentifier());
            }
        }
        throw new UnsupportedOperationException("Unsupported Beam fieldType: " + fieldType.getTypeName());
    }

    private static ArrayType createZetaSqlArrayTypeFromBeamElementFieldType(Schema.FieldType elementFieldType) {
        return TypeFactory.createArrayType((Type)ZetaSqlUtils.beamFieldTypeToZetaSqlType(elementFieldType));
    }

    public static StructType createZetaSqlStructTypeFromBeamSchema(Schema schema) {
        return TypeFactory.createStructType((Collection)schema.getFields().stream().map(ZetaSqlUtils::beamFieldToZetaSqlStructField).collect(Collectors.toList()));
    }

    private static StructType.StructField beamFieldToZetaSqlStructField(Schema.Field field) {
        return new StructType.StructField(field.getName(), ZetaSqlUtils.beamFieldTypeToZetaSqlType(field.getType()));
    }

    public static Value javaObjectToZetaSqlValue(Object object, Schema.FieldType fieldType) {
        if (object == null) {
            return Value.createNullValue((Type)ZetaSqlUtils.beamFieldTypeToZetaSqlType(fieldType));
        }
        switch (fieldType.getTypeName()) {
            case INT64: {
                return Value.createInt64Value((long)((Long)object));
            }
            case DOUBLE: {
                return Value.createDoubleValue((double)((Double)object));
            }
            case STRING: {
                return Value.createStringValue((String)((String)object));
            }
            case DATETIME: {
                return ZetaSqlUtils.jodaInstantToZetaSqlTimestampValue((Instant)object);
            }
            case BOOLEAN: {
                return Value.createBoolValue((boolean)((Boolean)object));
            }
            case BYTES: {
                return Value.createBytesValue((ByteString)ByteString.copyFrom((byte[])((byte[])object)));
            }
            case ARRAY: {
                return ZetaSqlUtils.javaListToZetaSqlArrayValue((List)object, fieldType.getCollectionElementType());
            }
            case ROW: {
                return ZetaSqlUtils.beamRowToZetaSqlStructValue((Row)object, fieldType.getRowSchema());
            }
        }
        throw new UnsupportedOperationException("Unsupported Beam fieldType: " + fieldType.getTypeName());
    }

    private static Value jodaInstantToZetaSqlTimestampValue(Instant instant) {
        return ZetaSqlUtils.javaLongToZetaSqlTimestampValue(instant.getMillis());
    }

    private static Value javaLongToZetaSqlTimestampValue(Long millis) {
        return Value.createTimestampValueFromUnixMicros((long)LongMath.checkedMultiply((long)millis, (long)1000L));
    }

    private static Value javaListToZetaSqlArrayValue(List<Object> elements, Schema.FieldType elementType) {
        List values = elements.stream().map(e -> ZetaSqlUtils.javaObjectToZetaSqlValue(e, elementType)).collect(Collectors.toList());
        return Value.createArrayValue((ArrayType)ZetaSqlUtils.createZetaSqlArrayTypeFromBeamElementFieldType(elementType), values);
    }

    public static Value beamRowToZetaSqlStructValue(Row row, Schema schema) {
        ArrayList<Value> values = new ArrayList<Value>(row.getFieldCount());
        for (int i = 0; i < row.getFieldCount(); ++i) {
            values.add(ZetaSqlUtils.javaObjectToZetaSqlValue(row.getBaseValue(i, Object.class), schema.getField(i).getType()));
        }
        return Value.createStructValue((StructType)ZetaSqlUtils.createZetaSqlStructTypeFromBeamSchema(schema), values);
    }

    public static Object zetaSqlValueToJavaObject(Value value, Schema.FieldType fieldType, boolean verifyValues) {
        if (value.isNull()) {
            return null;
        }
        switch (fieldType.getTypeName()) {
            case INT64: {
                return value.getInt64Value();
            }
            case DECIMAL: {
                return value.getNumericValue();
            }
            case DOUBLE: {
                if (value.getType().getKind().equals((Object)ZetaSQLType.TypeKind.TYPE_INT64)) {
                    return (double)value.getInt64Value();
                }
                return value.getDoubleValue();
            }
            case STRING: {
                return value.getStringValue();
            }
            case DATETIME: {
                return ZetaSqlUtils.zetaSqlTimestampValueToJodaInstant(value);
            }
            case BOOLEAN: {
                return value.getBoolValue();
            }
            case BYTES: {
                return value.getBytesValue().toByteArray();
            }
            case ARRAY: {
                return ZetaSqlUtils.zetaSqlArrayValueToJavaList(value, fieldType.getCollectionElementType(), verifyValues);
            }
            case ROW: {
                return ZetaSqlUtils.zetaSqlStructValueToBeamRow(value, fieldType.getRowSchema(), verifyValues);
            }
        }
        throw new UnsupportedOperationException("Unsupported Beam fieldType: " + fieldType.getTypeName());
    }

    private static Instant zetaSqlTimestampValueToJodaInstant(Value timestampValue) {
        long millis = timestampValue.getTimestampUnixMicros() / 1000L;
        return Instant.ofEpochMilli((long)millis);
    }

    private static List<Object> zetaSqlArrayValueToJavaList(Value arrayValue, Schema.FieldType elementType, boolean verifyValues) {
        return arrayValue.getElementList().stream().map(e -> ZetaSqlUtils.zetaSqlValueToJavaObject(e, elementType, verifyValues)).collect(Collectors.toList());
    }

    private static Row zetaSqlStructValueToBeamRow(Value structValue, Schema schema, boolean verifyValues) {
        ArrayList<Object> objects = new ArrayList<Object>(schema.getFieldCount());
        ImmutableList values = structValue.getFieldList();
        for (int i = 0; i < values.size(); ++i) {
            objects.add(ZetaSqlUtils.zetaSqlValueToJavaObject((Value)values.get(i), schema.getField(i).getType(), verifyValues));
        }
        Row row = verifyValues ? Row.withSchema((Schema)schema).addValues(objects).build() : Row.withSchema((Schema)schema).attachValues(objects);
        return row;
    }
}

