/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class ZetaSqlIdUtils {
    private static final Pattern SPECIAL_CHARS_ESCAPE = Pattern.compile("(?<SpecialChar>[\\\\`'\"?])");
    private static final ImmutableMap<String, String> WHITESPACES = ImmutableMap.of((Object)"\n", (Object)"\\\\n", (Object)"\t", (Object)"\\\\t", (Object)"\r", (Object)"\\\\r", (Object)"\f", (Object)"\\\\f");
    private static final Pattern SIMPLE_ID = Pattern.compile("[A-Za-z_][A-Za-z_0-9]*");

    ZetaSqlIdUtils() {
    }

    static String escapeAndJoin(List<String> parts) {
        String escaped = parts.stream().map(ZetaSqlIdUtils::escapeSpecialChars).map(ZetaSqlIdUtils::replaceWhitespaces).map(ZetaSqlIdUtils::backtickIfNeeded).collect(Collectors.joining("."));
        return escaped;
    }

    private static String escapeSpecialChars(String str) {
        return SPECIAL_CHARS_ESCAPE.matcher(str).replaceAll("\\\\${SpecialChar}");
    }

    private static String replaceWhitespaces(String s) {
        String result = s;
        for (String whitespace : WHITESPACES.keySet()) {
            result = result.replaceAll(whitespace, (String)WHITESPACES.get((Object)whitespace));
        }
        return result;
    }

    private static String backtickIfNeeded(String s) {
        return SIMPLE_ID.matcher(s).matches() ? s : "`" + s + "`";
    }
}

