/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.protobuf.ProtoByteBuddyUtils;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaTranslator;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProvider;
import org.apache.beam.sdk.schemas.RowMessages;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class ProtoMessageSchema
extends GetterBasedSchemaProvider {
    public <T> @Nullable @UnknownKeyFor @Initialized Schema schemaFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        this.checkForDynamicType(typeDescriptor);
        return ProtoSchemaTranslator.getSchema(typeDescriptor.getRawType());
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> fieldValueGetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return ProtoByteBuddyUtils.getGetters(targetClass, schema, new ProtoClassFieldValueTypeSupplier(), new ProtoByteBuddyUtils.ProtoTypeConversionsFactory());
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return JavaBeanUtils.getFieldTypes(targetClass, (Schema)schema, (FieldValueTypeSupplier)new ProtoClassFieldValueTypeSupplier());
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        SchemaUserTypeCreator creator = ProtoByteBuddyUtils.getBuilderCreator(targetClass, schema, new ProtoClassFieldValueTypeSupplier());
        if (creator == null) {
            throw new RuntimeException("Cannot create creator for " + targetClass);
        }
        return creator;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> getProtoBytesToRowFn(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        Class<Message> protoClass = ProtoMessageSchema.ensureMessageType(clazz);
        ProtoCoder<Message> protoCoder = ProtoCoder.of(protoClass);
        return RowMessages.bytesToRowFn((SchemaProvider)new ProtoMessageSchema(), (TypeDescriptor)TypeDescriptor.of(protoClass), (ProcessFunction & Serializable)bytes -> (Message)protoCoder.getParser().parseFrom(bytes));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getRowToProtoBytesFn(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        Class<Message> protoClass = ProtoMessageSchema.ensureMessageType(clazz);
        return RowMessages.rowToBytesFn((SchemaProvider)new ProtoMessageSchema(), (TypeDescriptor)TypeDescriptor.of(protoClass), MessageLite::toByteArray);
    }

    private <T> void checkForDynamicType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        if (typeDescriptor.getRawType().equals(DynamicMessage.class)) {
            throw new RuntimeException("DynamicMessage is not allowed for the standard ProtoSchemaProvider, use ProtoDynamicMessageSchema  instead.");
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized Message> ensureMessageType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        Preconditions.checkArgument((boolean)Message.class.isAssignableFrom(clazz), (String)"%s is not a subtype of %s", (Object)clazz.getName(), (Object)Message.class.getSimpleName());
        return clazz;
    }

    private static final class ProtoClassFieldValueTypeSupplier
    implements FieldValueTypeSupplier {
        private ProtoClassFieldValueTypeSupplier() {
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
            throw new RuntimeException("Unexpected call.");
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            Multimap methods = ReflectUtils.getMethodsMap(clazz);
            ArrayList types = Lists.newArrayListWithCapacity((int)schema.getFieldCount());
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                Schema.Field field = schema.getField(i);
                if (field.getType().isLogicalType("OneOf")) {
                    OneOfType oneOfType = (OneOfType)field.getType().getLogicalType(OneOfType.class);
                    HashMap oneOfTypes = Maps.newHashMap();
                    for (Schema.Field oneOfField : oneOfType.getOneOfSchema().getFields()) {
                        Method method = ProtoByteBuddyUtils.getProtoGetter((Multimap<String, Method>)methods, oneOfField.getName(), oneOfField.getType());
                        oneOfTypes.put(oneOfField.getName(), FieldValueTypeInformation.forGetter((Method)method, (int)i).withName(field.getName()));
                    }
                    types.add(FieldValueTypeInformation.forOneOf((String)field.getName(), (boolean)field.getType().getNullable(), (Map)oneOfTypes).withName(field.getName()));
                    continue;
                }
                Method method = ProtoByteBuddyUtils.getProtoGetter((Multimap<String, Method>)methods, field.getName(), field.getType());
                types.add(FieldValueTypeInformation.forGetter((Method)method, (int)i).withName(field.getName()));
            }
            return types;
        }
    }
}

