/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.beam.sdk.expansion.service.AutoValue_JavaClassLookupTransformProvider_AllowList;
import org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProvider;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;

public interface ExpansionServiceOptions
extends PipelineOptions {
    @Description(value="Allow list for Java class based transform expansion")
    @Default.InstanceFactory(value=JavaClassLookupAllowListFactory.class)
    public JavaClassLookupTransformProvider.AllowList getJavaClassLookupAllowlist();

    public void setJavaClassLookupAllowlist(JavaClassLookupTransformProvider.AllowList var1);

    @Description(value="Allow list file for Java class based transform expansion")
    public String getJavaClassLookupAllowlistFile();

    public void setJavaClassLookupAllowlistFile(String var1);

    public static class JavaClassLookupAllowListFactory
    implements DefaultValueFactory<JavaClassLookupTransformProvider.AllowList> {
        public JavaClassLookupTransformProvider.AllowList create(PipelineOptions options) {
            String allowListFile = ((ExpansionServiceOptions)options.as(ExpansionServiceOptions.class)).getJavaClassLookupAllowlistFile();
            if (allowListFile != null) {
                ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                File allowListFileObj = new File(allowListFile);
                if (!allowListFileObj.exists()) {
                    throw new IllegalArgumentException("Allow list file " + allowListFile + " does not exist");
                }
                try {
                    return (JavaClassLookupTransformProvider.AllowList)mapper.readValue(allowListFileObj, JavaClassLookupTransformProvider.AllowList.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not load the provided allowlist file " + allowListFile, e);
                }
            }
            return new AutoValue_JavaClassLookupTransformProvider_AllowList("v1", new ArrayList<JavaClassLookupTransformProvider.AllowedClass>());
        }
    }
}

