/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Queue;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.collect.Lists;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public final class CreateStream<T>
extends PTransform<PBegin, PCollection<T>> {
    private final Duration batchDuration;
    private final Queue<Iterable<TimestampedValue<T>>> batches = new ArrayDeque<Iterable<TimestampedValue<T>>>();
    private final Deque<GlobalWatermarkHolder.SparkWatermarks> times = new ArrayDeque<GlobalWatermarkHolder.SparkWatermarks>();
    private final Coder<T> coder;
    private Instant initialSystemTime;
    private final boolean forceWatermarkSync;
    private Instant lowWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE;

    private CreateStream(Duration batchDuration, Instant initialSystemTime, Coder<T> coder, boolean forceWatermarkSync) {
        this.batchDuration = batchDuration;
        this.initialSystemTime = initialSystemTime;
        this.coder = coder;
        this.forceWatermarkSync = forceWatermarkSync;
    }

    public static <T> CreateStream<T> of(Coder<T> coder, Duration batchDuration, boolean forceWatermarkSync) {
        return new CreateStream<T>(batchDuration, new Instant(0L), coder, forceWatermarkSync);
    }

    public static <T> CreateStream<T> of(Coder<T> coder, Duration batchDuration) {
        return CreateStream.of(coder, batchDuration, true);
    }

    @SafeVarargs
    public final CreateStream<T> nextBatch(TimestampedValue<T> ... batchElements) {
        for (TimestampedValue<T> timestampedValue : batchElements) {
            Preconditions.checkArgument(timestampedValue.getTimestamp().isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), "Elements must have timestamps before %s. Got: %s", (Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)timestampedValue.getTimestamp());
        }
        this.batches.offer(Arrays.asList(batchElements));
        return this;
    }

    @SafeVarargs
    public final CreateStream<T> nextBatch(T ... batchElements) {
        ArrayList<TimestampedValue> timestamped = Lists.newArrayListWithCapacity(batchElements.length);
        for (T element : batchElements) {
            timestamped.add(TimestampedValue.atMinimumTimestamp(element));
        }
        this.batches.offer(timestamped);
        return this;
    }

    public CreateStream<T> emptyBatch() {
        this.batches.offer(Collections.emptyList());
        return this;
    }

    public CreateStream<T> initialSystemTimeAt(Instant initialSystemTime) {
        this.initialSystemTime = initialSystemTime;
        return this;
    }

    public CreateStream<T> advanceWatermarkForNextBatch(Instant newWatermark) {
        Preconditions.checkArgument(!newWatermark.isBefore((ReadableInstant)this.lowWatermark), "The watermark is not allowed to decrease!");
        Preconditions.checkArgument(newWatermark.isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), "The Watermark cannot progress beyond the maximum. Got: %s. Maximum: %s", (Object)newWatermark, (Object)BoundedWindow.TIMESTAMP_MAX_VALUE);
        return this.advance(newWatermark);
    }

    public CreateStream<T> advanceNextBatchWatermarkToInfinity() {
        return this.advance(BoundedWindow.TIMESTAMP_MAX_VALUE);
    }

    private CreateStream<T> advance(Instant newWatermark) {
        Instant currentSynchronizedProcessingTime = this.times.peekLast() == null ? this.initialSystemTime : this.times.peekLast().getSynchronizedProcessingTime();
        Instant nextSynchronizedProcessingTime = currentSynchronizedProcessingTime.plus((ReadableDuration)this.batchDuration);
        Preconditions.checkArgument(nextSynchronizedProcessingTime.isAfter((ReadableInstant)currentSynchronizedProcessingTime), "Synchronized processing time must always advance.");
        this.times.offer(new GlobalWatermarkHolder.SparkWatermarks(this.lowWatermark, newWatermark, nextSynchronizedProcessingTime));
        this.lowWatermark = newWatermark;
        return this;
    }

    public long getBatchDuration() {
        return this.batchDuration.getMillis();
    }

    public Queue<Iterable<TimestampedValue<T>>> getBatches() {
        return this.batches;
    }

    public Queue<GlobalWatermarkHolder.SparkWatermarks> getTimes() {
        return this.times;
    }

    public boolean isForceWatermarkSync() {
        return this.forceWatermarkSync;
    }

    public PCollection<T> expand(PBegin input) {
        return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, this.coder);
    }
}

