/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.base.Function;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.base.Optional;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.base.Predicate;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.base.Predicates;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.collect.FluentIterable;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.collect.ImmutableSortedMap;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.collect.Maps;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.collect.Ordering;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.runners.spark.metrics.AggregatorMetric;
import org.apache.beam.runners.spark.metrics.SparkBeamMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithMetricsSupport
extends MetricRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WithMetricsSupport.class);
    private final MetricRegistry internalMetricRegistry;

    private WithMetricsSupport(MetricRegistry internalMetricRegistry) {
        this.internalMetricRegistry = internalMetricRegistry;
    }

    public static WithMetricsSupport forRegistry(MetricRegistry metricRegistry) {
        return new WithMetricsSupport(metricRegistry);
    }

    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.internalMetricRegistry.getTimers(filter);
    }

    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.internalMetricRegistry.getMeters(filter);
    }

    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.internalMetricRegistry.getHistograms(filter);
    }

    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.internalMetricRegistry.getCounters(filter);
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return ((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)new ImmutableSortedMap.Builder(Ordering.from(String.CASE_INSENSITIVE_ORDER)).putAll((Map)this.internalMetricRegistry.getGauges(filter))).putAll(this.extractGauges(this.internalMetricRegistry, filter))).build();
    }

    private Map<String, Gauge> extractGauges(MetricRegistry metricRegistry, MetricFilter filter) {
        HashMap<String, Gauge> gauges = new HashMap<String, Gauge>();
        Optional<Map<String, Gauge>> aggregatorMetrics = FluentIterable.from(metricRegistry.getMetrics().entrySet()).firstMatch(this.isAggregatorMetric()).transform(this.aggregatorMetricToGauges());
        Optional<Map<String, Gauge>> beamMetrics = FluentIterable.from(metricRegistry.getMetrics().entrySet()).firstMatch(this.isSparkBeamMetric()).transform(this.beamMetricToGauges());
        if (aggregatorMetrics.isPresent()) {
            gauges.putAll(Maps.filterEntries(aggregatorMetrics.get(), this.matches(filter)));
        }
        if (beamMetrics.isPresent()) {
            gauges.putAll(Maps.filterEntries(beamMetrics.get(), this.matches(filter)));
        }
        return gauges;
    }

    private Function<Map.Entry<String, Metric>, Map<String, Gauge>> aggregatorMetricToGauges() {
        return entry -> {
            NamedAggregators agg = ((AggregatorMetric)entry.getValue()).getNamedAggregators();
            String parentName = (String)entry.getKey();
            Map<String, Gauge> gaugeMap = Maps.transformEntries(agg.renderAll(), this.toGauge());
            LinkedHashMap<String, Gauge> fullNameGaugeMap = Maps.newLinkedHashMap();
            for (Map.Entry<String, Gauge> gaugeEntry : gaugeMap.entrySet()) {
                fullNameGaugeMap.put(parentName + "." + gaugeEntry.getKey(), gaugeEntry.getValue());
            }
            return Maps.filterValues(fullNameGaugeMap, Predicates.notNull());
        };
    }

    private Function<Map.Entry<String, Metric>, Map<String, Gauge>> beamMetricToGauges() {
        return entry -> {
            Map<String, ?> metrics = ((SparkBeamMetric)entry.getValue()).renderAll();
            String parentName = (String)entry.getKey();
            Map<String, Gauge> gaugeMap = Maps.transformEntries(metrics, this.toGauge());
            LinkedHashMap<String, Gauge> fullNameGaugeMap = Maps.newLinkedHashMap();
            for (Map.Entry<String, Gauge> gaugeEntry : gaugeMap.entrySet()) {
                fullNameGaugeMap.put(parentName + "." + gaugeEntry.getKey(), gaugeEntry.getValue());
            }
            return Maps.filterValues(fullNameGaugeMap, Predicates.notNull());
        };
    }

    private Maps.EntryTransformer<String, Object, Gauge> toGauge() {
        return (name, rawValue) -> () -> {
            try {
                return Double.parseDouble(rawValue.toString());
            }
            catch (Exception e) {
                LOG.warn("Failed reporting metric with name [{}], of type [{}], since it could not be converted to double", new Object[]{name, rawValue.getClass().getSimpleName(), e});
                return null;
            }
        };
    }

    private Predicate<Map.Entry<String, Gauge>> matches(MetricFilter filter) {
        return entry -> filter.matches((String)entry.getKey(), (Metric)entry.getValue());
    }

    private Predicate<Map.Entry<String, Metric>> isAggregatorMetric() {
        return metricEntry -> metricEntry.getValue() instanceof AggregatorMetric;
    }

    private Predicate<Map.Entry<String, Metric>> isSparkBeamMetric() {
        return metricEntry -> metricEntry.getValue() instanceof SparkBeamMetric;
    }
}

