/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.CoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.ObjectType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class EncoderHelpers {
    private static final @UnknownKeyFor @NonNull @Initialized DataType OBJECT_TYPE = new ObjectType(Object.class);

    public static <T> @UnknownKeyFor @NonNull @Initialized Encoder<T> fromBeamCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        Class clazz = coder.getEncodedTypeDescriptor().getRawType();
        return EncoderFactory.create(EncoderHelpers.beamSerializer(EncoderHelpers.rootRef(OBJECT_TYPE, true), coder), EncoderHelpers.beamDeserializer(EncoderHelpers.rootCol(DataTypes.BinaryType), coder), clazz);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression beamSerializer(@UnknownKeyFor @NonNull @Initialized Expression obj, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        Expression[] args = new Expression[]{obj, EncoderHelpers.lit(coder, Coder.class)};
        return EncoderFactory.invokeIfNotNull(CoderHelpers.class, "toByteArray", DataTypes.BinaryType, args);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Expression beamDeserializer(@UnknownKeyFor @NonNull @Initialized Expression bytes, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        Expression[] args = new Expression[]{bytes, EncoderHelpers.lit(coder, Coder.class)};
        return EncoderFactory.invokeIfNotNull(CoderHelpers.class, "fromByteArray", OBJECT_TYPE, args);
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression rootRef(@UnknownKeyFor @NonNull @Initialized DataType dt, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        return new BoundReference(0, dt, nullable);
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression rootCol(@UnknownKeyFor @NonNull @Initialized DataType dt) {
        return new GetColumnByOrdinal(0, dt);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Literal lit(T obj, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends T> cls) {
        return Literal.fromObject(obj, (DataType)new ObjectType(cls));
    }
}

