/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

class SideInputStorage {
    private static final Cache<Key<?>, Value<?>> materializedSideInputs = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    SideInputStorage() {
    }

    static Cache<Key<?>, Value<?>> getMaterializedSideInputs() {
        return materializedSideInputs;
    }

    public static class Value<T> {
        final T value;

        Value(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class Key<T> {
        private final PCollectionView<T> view;
        private final BoundedWindow window;

        Key(PCollectionView<T> view, BoundedWindow window) {
            this.view = view;
            this.window = window;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.view, key.view) && Objects.equals(this.window, key.window);
        }

        public int hashCode() {
            return Objects.hash(this.view, this.window);
        }

        public String toString() {
            String pName = this.view.getPCollection() != null ? this.view.getPCollection().getName() : "Unknown";
            return "Key{view=" + this.view.getTagInternal() + " of PCollection[" + pName + "], window=" + this.window + '}';
        }
    }
}

