/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.CoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.ObjectType;
import org.checkerframework.checker.nullness.qual.Nullable;
import scala.StringContext;
import scala.collection.JavaConversions;
import scala.reflect.ClassTag;

public class EncoderHelpers {
    public static <T> Encoder<T> fromBeamCoder(Coder<T> coder) {
        return EncoderFactory.fromBeamCoder(coder);
    }

    public static class DecodeUsingBeamCoder<T>
    extends UnaryExpression
    implements NonSQLExpression,
    Serializable {
        private final Expression child;
        private final ClassTag<T> classTag;
        private final Coder<T> coder;

        public DecodeUsingBeamCoder(Expression child, ClassTag<T> classTag, Coder<T> coder) {
            this.child = child;
            this.classTag = classTag;
            this.coder = coder;
        }

        public Expression child() {
            return this.child;
        }

        public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
            String accessCode = ctx.addReferenceObj("coder", this.coder, this.coder.getClass().getName());
            ExprCode input = this.child.genCode(ctx);
            String javaType = CodeGenerator.javaType((DataType)this.dataType());
            ArrayList<String> parts = new ArrayList<String>();
            ArrayList<String> args = new ArrayList<String>();
            parts.add("final ");
            args.add(javaType);
            parts.add(" ");
            args.add((String)ev.value());
            parts.add(" = (");
            args.add(javaType);
            parts.add(") org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers.DecodeUsingBeamCoder.decode(");
            args.add((String)input.isNull());
            parts.add(", ");
            args.add((String)input.value());
            parts.add(", ");
            args.add(accessCode);
            parts.add(");");
            StringContext sc = new StringContext(JavaConversions.collectionAsScalaIterable(parts).toSeq());
            Block code = new Block.BlockHelper(sc).code(JavaConversions.collectionAsScalaIterable(args).toSeq());
            return ev.copy(input.code().$plus(code), input.isNull(), ev.value());
        }

        public DataType dataType() {
            return new ObjectType(this.classTag.runtimeClass());
        }

        public Object productElement(int n) {
            switch (n) {
                case 0: {
                    return this.child;
                }
                case 1: {
                    return this.classTag;
                }
                case 2: {
                    return this.coder;
                }
            }
            throw new ArrayIndexOutOfBoundsException("productElement out of bounds");
        }

        public int productArity() {
            return 3;
        }

        public boolean canEqual(Object that) {
            return that instanceof DecodeUsingBeamCoder;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecodeUsingBeamCoder that = (DecodeUsingBeamCoder)o;
            return this.child.equals(that.child) && this.classTag.equals(that.classTag) && this.coder.equals(that.coder);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.child, this.classTag, this.coder);
        }

        public static <T> T decode(boolean isNull, byte @Nullable [] serialized, Coder<T> coder) {
            return isNull ? null : (T)CoderHelpers.fromByteArray(serialized, coder);
        }
    }

    public static class EncodeUsingBeamCoder<T>
    extends UnaryExpression
    implements NonSQLExpression,
    Serializable {
        private final Expression child;
        private final Coder<T> coder;

        public EncodeUsingBeamCoder(Expression child, Coder<T> coder) {
            this.child = child;
            this.coder = coder;
        }

        public Expression child() {
            return this.child;
        }

        public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
            String accessCode = ctx.addReferenceObj("coder", this.coder, this.coder.getClass().getName());
            ExprCode input = this.child.genCode(ctx);
            String javaType = CodeGenerator.javaType((DataType)this.dataType());
            ArrayList<String> parts = new ArrayList<String>();
            ArrayList<String> args = new ArrayList<String>();
            parts.add("final ");
            args.add(javaType);
            parts.add(" ");
            args.add((String)ev.value());
            parts.add(" = org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers.EncodeUsingBeamCoder.encode(");
            args.add((String)input.isNull());
            parts.add(", ");
            args.add((String)input.value());
            parts.add(", ");
            args.add(accessCode);
            parts.add(");");
            StringContext sc = new StringContext(JavaConversions.collectionAsScalaIterable(parts).toSeq());
            Block code = new Block.BlockHelper(sc).code(JavaConversions.collectionAsScalaIterable(args).toSeq());
            return ev.copy(input.code().$plus(code), input.isNull(), ev.value());
        }

        public DataType dataType() {
            return DataTypes.BinaryType;
        }

        public Object productElement(int n) {
            switch (n) {
                case 0: {
                    return this.child;
                }
                case 1: {
                    return this.coder;
                }
            }
            throw new ArrayIndexOutOfBoundsException("productElement out of bounds");
        }

        public int productArity() {
            return 2;
        }

        public boolean canEqual(Object that) {
            return that instanceof EncodeUsingBeamCoder;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EncodeUsingBeamCoder that = (EncodeUsingBeamCoder)o;
            return this.child.equals(that.child) && this.coder.equals(that.coder);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.child, this.coder);
        }

        public static <T> byte[] encode(boolean isNull, @Nullable T value, Coder<T> coder) {
            return isNull ? null : CoderHelpers.toByteArray(value, coder);
        }
    }
}

