/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import com.codahale.metrics.Metric;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;

class SparkBeamMetric
implements Metric {
    private static final String ILLEGAL_CHARACTERS = "[^A-Za-z0-9\\._-]";
    private static final String ILLEGAL_CHARACTERS_AND_PERIOD = "[^A-Za-z0-9_-]";

    SparkBeamMetric() {
    }

    Map<String, ?> renderAll() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        MetricResults metricResults = MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)((MetricsContainerStepMap)MetricsAccumulator.getInstance().value()));
        MetricQueryResults metricQueryResults = metricResults.queryMetrics(MetricsFilter.builder().build());
        for (MetricResult metricResult : metricQueryResults.counters()) {
            metrics.put(this.renderName(metricResult), metricResult.attempted());
        }
        for (MetricResult metricResult : metricQueryResults.distributions()) {
            DistributionResult result = (DistributionResult)metricResult.attempted();
            metrics.put(this.renderName(metricResult) + ".count", result.count());
            metrics.put(this.renderName(metricResult) + ".sum", result.sum());
            metrics.put(this.renderName(metricResult) + ".min", result.min());
            metrics.put(this.renderName(metricResult) + ".max", result.max());
            metrics.put(this.renderName(metricResult) + ".mean", result.mean());
        }
        for (MetricResult metricResult : metricQueryResults.gauges()) {
            metrics.put(this.renderName(metricResult), ((GaugeResult)metricResult.attempted()).value());
        }
        return metrics;
    }

    @VisibleForTesting
    String renderName(MetricResult<?> metricResult) {
        String renderedStepName = metricResult.step().replaceAll(ILLEGAL_CHARACTERS_AND_PERIOD, "_");
        if (renderedStepName.endsWith("_")) {
            renderedStepName = renderedStepName.substring(0, renderedStepName.length() - 1);
        }
        MetricName metricName = metricResult.name();
        return (renderedStepName + "." + metricName.namespace() + "." + metricName.name()).replaceAll(ILLEGAL_CHARACTERS, "_");
    }
}

